/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.webconsole.internal.plugins;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.felix.webconsole.internal.core.InstallAction;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.spi.util.BundleInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class InstallActionExt
extends InstallAction {
    @Override
    protected void installBackground(final File bundleFile, String location, final int startlevel, final boolean doStart, boolean refreshPackages) {
        BundleContext context = this.getBundleContext();
        ServiceReference sref = context.getServiceReference(DeployerService.class.getName());
        if (sref == null) {
            this.getLog().log(2, "Cannot obtain service: " + DeployerService.class.getName());
            super.installBackground(bundleFile, location, startlevel, doStart, refreshPackages);
            return;
        }
        final DeployerService deployer = (DeployerService)context.getService(sref);
        InstallAction.InstallHelper t = new InstallAction.InstallHelper(this, "Background Install " + bundleFile, bundleFile, refreshPackages){

            @Override
            protected Bundle doRun(InputStream bundleStream) throws BundleException {
                URL bundleURL = InstallActionExt.this.getBundleURL(bundleFile);
                BundleInfo info = BundleInfo.createBundleInfo((URL)bundleURL);
                Deployment dep = DeploymentFactory.createDeployment((BundleInfo)info);
                dep.setStartLevel(Integer.valueOf(startlevel));
                dep.setAutoStart(doStart);
                deployer.deploy(new Deployment[]{dep});
                Bundle bundle = InstallActionExt.this.getBundle(dep);
                if (bundle == null) {
                    throw new IllegalStateException("Cannot obtain installed bundle: " + dep);
                }
                return bundle;
            }
        };
        t.start();
    }

    private Bundle getBundle(Deployment dep) {
        String symbolicName = dep.getSymbolicName();
        Version version = Version.parseVersion((String)dep.getVersion());
        Bundle bundle = null;
        for (Bundle aux : this.getBundleContext().getBundles()) {
            if (!aux.getSymbolicName().equals(symbolicName) || !version.equals((Object)aux.getVersion())) continue;
            bundle = aux;
            break;
        }
        return bundle;
    }

    private URL getBundleURL(File bundleFile) throws BundleException {
        URL bundleURL;
        try {
            bundleURL = bundleFile.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new BundleException(ex.getMessage());
        }
        return bundleURL;
    }
}

