/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.jbossxb.internal;

//$Id: XMLBindingActivator.java 91540 2009-07-22 08:12:03Z thomas.diesler@jboss.com $

import javax.xml.parsers.SAXParserFactory;

import org.jboss.osgi.common.log.LogServiceTracker;
import org.jboss.osgi.jbossxb.XMLBindingService;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.parser.sax.SaxJBossXBParser;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

/**
 * A {@link BundleActivator} that initializes the JBossXB bundle 
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public class XMLBindingActivator implements BundleActivator
{
   private LogService log;

   public void start(BundleContext context) throws Exception
   {
      log = new LogServiceTracker(context);

      ServiceTracker saxTracker = new ServiceTracker(context, SAXParserFactory.class.getName(), null)
      {
         @Override
         public Object addingService(ServiceReference reference)
         {
            SAXParserFactory saxFactory = (SAXParserFactory)super.addingService(reference);
            if (context.getServiceReference(XMLBindingService.class.getName()) == null)
            {
               log.log(LogService.LOG_DEBUG, "JBossXB SAXParserFactory: " + saxFactory);

               ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
               try
               {
                  Thread.currentThread().setContextClassLoader(getClass().getClassLoader());
                  try
                  {
                     // SaxJBossXBParser initializes the SAXParserFactory in a static block
                     // using SAXParserFactory.newInstance(), which internally uses the TCCL
                     new SaxJBossXBParser();
                  }
                  catch (JBossXBException ex)
                  {
                     throw new IllegalStateException("Cannot initialize SaxJBossXBParser", ex);
                  }

                  // Register the XMLBindingService
                  XMLBindingService service = new XMLBindingService(){};
                  context.registerService(XMLBindingService.class.getName(), service, null);
                  log.log(LogService.LOG_INFO, "XMLBindingService registered");
               }
               finally
               {
                  Thread.currentThread().setContextClassLoader(ctxLoader);
               }
            }
            return saxFactory;
         }
      };
      saxTracker.open();
   }

   public void stop(BundleContext context) throws Exception
   {
   }
}