/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jbossxb.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.jboss.osgi.jbossxb.UnmarshallerService;
import org.jboss.osgi.spi.util.BundleClassLoader;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmarshallerServiceImpl
implements UnmarshallerService {
    private static Logger log = LoggerFactory.getLogger(UnmarshallerServiceImpl.class);
    private UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
    private Unmarshaller unmarshaller;
    private JBossEntityResolver entityResolver;
    private DefaultSchemaResolver schemaBindingResolver = new DefaultSchemaResolver();
    private BundleClassLoader bundleLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnmarshallerServiceImpl(BundleContext context) {
        this.bundleLoader = BundleClassLoader.createClassLoader((Bundle)context.getBundle());
        log.debug("UnmarshallerService using: " + this.bundleLoader);
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.unmarshaller = this.factory.newUnmarshaller();
        }
        catch (Throwable th) {
            log.error("Cannot initialze unmarshaller", th);
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
    }

    @Override
    public void setFeature(String featureName, boolean flag) {
        this.factory.setFeature(featureName, (Object)flag);
        this.unmarshaller = null;
    }

    @Override
    public void setNamespaceAware(boolean namespaces) {
        try {
            this.getUnmarshaller().setNamespaceAware(namespaces);
        }
        catch (JBossXBException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void setSchemaValidation(boolean validation) {
        try {
            this.getUnmarshaller().setSchemaValidation(validation);
        }
        catch (JBossXBException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void setValidation(boolean validation) {
        try {
            this.getUnmarshaller().setValidation(validation);
        }
        catch (JBossXBException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.getUnmarshaller().setErrorHandler(errorHandler);
    }

    @Override
    public void registerSchemaLocation(String id, String dtdOrSchema) {
        if (this.entityResolver == null) {
            try {
                this.entityResolver = new JBossEntityResolver();
                this.getUnmarshaller().setEntityResolver((EntityResolver)this.entityResolver);
            }
            catch (JBossXBException ex) {
                throw new IllegalStateException(ex);
            }
        }
        this.entityResolver.registerLocalEntity(id, dtdOrSchema);
        log.debug("Register [" + id + "=" + dtdOrSchema + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClassBinding(String nsUri, String className) {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.bundleLoader);
            this.schemaBindingResolver.addClassBinding(nsUri, className);
            if (log.isTraceEnabled()) {
                log.trace("Add mapping of '" + nsUri + "' to " + className);
            }
        }
        catch (ClassNotFoundException ex) {
            if (log.isTraceEnabled()) {
                log.trace("Ignore mapping of '" + nsUri + "' to " + className);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
    }

    @Override
    public void addClassBinding(String nsUri, Class<?> clazz) {
        this.schemaBindingResolver.addClassBinding(nsUri, clazz);
    }

    @Override
    public Object unmarshal(Reader xmlReader) throws IOException {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.bundleLoader);
            Object object = this.getUnmarshaller().unmarshal(xmlReader, (SchemaBindingResolver)this.schemaBindingResolver);
            return object;
        }
        catch (JBossXBException ex) {
            IOException ioex = new IOException("Cannot unmarshall xmlReader");
            ioex.initCause(ex);
            throw ioex;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
    }

    @Override
    public Object unmarshal(InputStream xmlStream) throws IOException {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.bundleLoader);
            Object object = this.getUnmarshaller().unmarshal(xmlStream, (SchemaBindingResolver)this.schemaBindingResolver);
            return object;
        }
        catch (JBossXBException ex) {
            IOException ioex = new IOException("Cannot unmarshall xmlStream");
            ioex.initCause(ex);
            throw ioex;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
    }

    @Override
    public Object unmarshal(InputSource source) throws IOException {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.bundleLoader);
            Object object = this.getUnmarshaller().unmarshal(source, (SchemaBindingResolver)this.schemaBindingResolver);
            return object;
        }
        catch (JBossXBException ex) {
            IOException ioex = new IOException("Cannot unmarshall input source");
            ioex.initCause(ex);
            throw ioex;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
    }

    @Override
    public Object unmarshal(String xml) throws IOException {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.bundleLoader);
            Object object = this.getUnmarshaller().unmarshal(xml, (SchemaBindingResolver)this.schemaBindingResolver);
            return object;
        }
        catch (JBossXBException ex) {
            IOException ioex = new IOException("Cannot unmarshall: " + xml);
            ioex.initCause(ex);
            throw ioex;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
    }

    private Unmarshaller getUnmarshaller() {
        if (this.unmarshaller == null) {
            this.unmarshaller = this.factory.newUnmarshaller();
        }
        return this.unmarshaller;
    }
}

