/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.jbossxb;

//$Id: UnmarshallerService.java 97115 2009-11-27 17:48:55Z thomas.diesler@jboss.com $

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

/**
 * An unmarshaller service
 * 
 * @author thomas.diesler@jboss.com
 * @since 26-Nov-2009
 */
public interface UnmarshallerService
{
   void setFeature(String featureName, boolean flag);
   
   void setValidation(boolean validation);

   void setNamespaceAware(boolean namespaces);

   void setSchemaValidation(boolean validation);
   
   void setErrorHandler(ErrorHandler errorHandler);
   
   void registerSchemaLocation(String id, String dtdOrSchema);

   void addClassBinding(String nsUri, String className);

   void addClassBinding(String nsUri, Class<?> clazz);

   Object unmarshal(Reader xmlReader) throws IOException;

   Object unmarshal(InputStream xmlStream) throws IOException;

   Object unmarshal(InputSource source) throws IOException;

   Object unmarshal(String xml) throws IOException;
}