/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.jbossxb.internal;

//$Id: XMLBindingActivator.java 97174 2009-11-30 16:09:19Z thomas.diesler@jboss.com $

import org.jboss.osgi.jbossxb.UnmarshallerService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

/**
 * A {@link BundleActivator} that initializes the JBossXB bundle 
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public class XMLBindingActivator implements BundleActivator
{
   public void start(BundleContext context) throws Exception
   {
      // Register a service factory that creates an JBossXB unmarshaller
      // in the context of the client bundle
      ServiceFactory serviceFactory = new ServiceFactory()
      {
         public Object getService(Bundle bundle, ServiceRegistration registration)
         {
            XMLBindingSAXParserFactory.setBundleContext(bundle.getBundleContext());
            XMLBindingDocumentBuilderFactory.setBundleContext(bundle.getBundleContext());
            return new UnmarshallerServiceImpl(bundle.getBundleContext());
         }

         public void ungetService(Bundle bundle, ServiceRegistration registration, Object service)
         {
            XMLBindingSAXParserFactory.setBundleContext(null);
            XMLBindingDocumentBuilderFactory.setBundleContext(null);
         }
      };
      context.registerService(UnmarshallerService.class.getName(), serviceFactory, null);
   }

   public void stop(BundleContext context) throws Exception
   {
   }
}