/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.deployer;

// $Id:$

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

/**
 * Sets the bundle's start level on the StartLevel service.
 * 
 * A start level can be given when the bundle is deployed through the 
 * WebConsole. Currently, neither hot deployment nor SPI test framework
 * deployments support start levels.
 *
 * @author Thomas.Diesler@jboss.com
 * @since 08-Jul-2009
 */
public class BundleStartLevelDeployer extends AbstractSimpleRealDeployer<Bundle>
{
   private BundleContext systemContext;
   private ServiceTracker startLevelTracker;

   public BundleStartLevelDeployer()
   {
      super(Bundle.class);
   }

   public void setSystemContext(BundleContext systemContext)
   {
      this.systemContext = systemContext;
   }

   public void deploy(DeploymentUnit unit, Bundle bundle) throws DeploymentException
   {
      Deployment dep = unit.getAttachment(Deployment.class);
      Integer propStart = dep != null ? dep.getStartLevel() : null;
      
      StartLevel startLevel = getStartLevel();
      if (propStart != null && startLevel != null)
      {
         startLevel.setBundleStartLevel(bundle, propStart);
      }
   }
   
   private StartLevel getStartLevel()
   {
      if (startLevelTracker == null)
      {
         startLevelTracker = new ServiceTracker(systemContext, StartLevel.class.getName(), null);
         startLevelTracker.open();
      }
      return (StartLevel)startLevelTracker.getService();
   }
}