/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment.deployer;

import org.jboss.osgi.deployment.DeploymentLogger;
import org.jboss.osgi.deployment.DeploymentMessages;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;

public class SystemDeployerService
implements DeployerService {
    private final BundleContext context;
    private final StartLevel startLevel;

    public SystemDeployerService(BundleContext context) {
        if (context == null) {
            throw DeploymentMessages.MESSAGES.illegalArgumentNull("context");
        }
        this.context = context;
        ServiceReference sref = context.getServiceReference(StartLevel.class.getName());
        this.startLevel = sref != null ? (StartLevel)context.getService(sref) : null;
    }

    @Override
    public Bundle deploy(Deployment dep) throws BundleException {
        Bundle bundle2 = this.deployInternal(dep);
        this.startInternal(dep);
        return bundle2;
    }

    @Override
    public Bundle undeploy(Deployment dep) throws BundleException {
        return this.undeployInternal(dep);
    }

    @Override
    public void deploy(Deployment[] depArr) throws BundleException {
        for (Deployment dep : depArr) {
            this.deployInternal(dep);
        }
        for (Deployment dep : depArr) {
            this.startInternal(dep);
        }
    }

    @Override
    public void undeploy(Deployment[] depArr) throws BundleException {
        for (Deployment dep : depArr) {
            this.undeployInternal(dep);
        }
    }

    private Bundle deployInternal(Deployment dep) throws BundleException {
        DeploymentLogger.LOGGER.debugf("Deploy: %s", dep);
        Bundle bundle2 = this.installBundle(dep);
        dep.addAttachment(Bundle.class, bundle2);
        Integer level = dep.getStartLevel();
        if (this.startLevel != null && level != null && level > 0) {
            this.startLevel.setBundleStartLevel(bundle2, level.intValue());
        }
        return bundle2;
    }

    private void startInternal(Deployment dep) throws BundleException {
        Bundle bundle2 = (Bundle)dep.getAttachment(Bundle.class);
        if (bundle2 != null && dep.isAutoStart()) {
            DeploymentLogger.LOGGER.debugf("Start: %s", bundle2);
            bundle2.start();
        }
    }

    private Bundle undeployInternal(Deployment dep) {
        DeploymentLogger.LOGGER.debugf("Undeploy: %s", dep);
        Bundle bundle2 = (Bundle)dep.getAttachment(Bundle.class);
        if (bundle2 == null) {
            DeploymentLogger.LOGGER.warnCannotObtainBundleForDeployment(dep);
            return null;
        }
        try {
            if (bundle2.getState() != 1) {
                DeploymentLogger.LOGGER.debugf("Uninstall: %s", bundle2);
                this.uninstallBundle(dep, bundle2);
            }
        }
        catch (Throwable ex) {
            DeploymentLogger.LOGGER.warnCannotUninstallBundleForDeployment(ex, dep);
        }
        return bundle2;
    }

    protected Bundle installBundle(Deployment dep) throws BundleException {
        return this.context.installBundle(dep.getLocation());
    }

    protected void uninstallBundle(Deployment dep, Bundle bundle2) throws BundleException {
        bundle2.uninstall();
    }
}

