/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment.internal;

import java.io.IOException;
import java.net.URL;
import org.jboss.osgi.deployment.DeploymentMessages;
import org.jboss.osgi.deployment.internal.AbstractDeployment;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Version;

public class VirtualFileDeployment
extends AbstractDeployment {
    private static final long serialVersionUID = -3331145101532992381L;
    private transient VirtualFile rootFile;
    private URL rootURL;

    public VirtualFileDeployment(VirtualFile rootFile, String location, String symbolicName, Version version) {
        super(location, symbolicName, version);
        if (rootFile == null) {
            throw DeploymentMessages.MESSAGES.illegalArgumentNull("rootFile");
        }
        try {
            this.rootFile = rootFile;
            this.rootURL = rootFile.toURL();
        }
        catch (IOException ex) {
            throw DeploymentMessages.MESSAGES.illegalStateCannotObtainRootURL(ex);
        }
    }

    @Override
    public VirtualFile getRoot() {
        if (this.rootFile == null) {
            try {
                this.rootFile = AbstractVFS.toVirtualFile((URL)this.rootURL);
            }
            catch (IOException ex) {
                throw DeploymentMessages.MESSAGES.illegalStateCannotObtainRootFile(ex);
            }
        }
        return this.rootFile;
    }
}

