/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment.interceptor;

import org.jboss.osgi.deployment.DeploymentMessages;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.spi.Attachable;
import org.jboss.osgi.spi.AttachmentKey;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class AbstractInvocationContext
implements InvocationContext {
    private Attachable attachments;
    private BundleContext systemContext;
    private VirtualFile root;
    private Bundle bundle;

    public AbstractInvocationContext(BundleContext systemContext, Bundle bundle2, VirtualFile root, Attachable attachments) {
        if (systemContext == null) {
            throw DeploymentMessages.MESSAGES.illegalArgumentNull("context");
        }
        if (bundle2 == null) {
            throw DeploymentMessages.MESSAGES.illegalArgumentNull("bundle");
        }
        if (attachments == null) {
            throw DeploymentMessages.MESSAGES.illegalArgumentNull("attachments");
        }
        this.systemContext = systemContext;
        this.root = root;
        this.bundle = bundle2;
        this.attachments = attachments;
    }

    @Override
    public BundleContext getSystemContext() {
        return this.systemContext;
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public VirtualFile getRoot() {
        return this.root;
    }

    public <T> T putAttachment(AttachmentKey<T> key, T value) {
        return (T)this.attachments.putAttachment(key, value);
    }

    public <T> T getAttachment(AttachmentKey<T> type) {
        return (T)this.attachments.getAttachment(type);
    }

    public <T> T removeAttachment(AttachmentKey<T> clazz) {
        return (T)this.attachments.removeAttachment(clazz);
    }
}

