/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment.deployer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentRegistryService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class SystemDeployerService
implements DeployerService {
    private static final Logger log = Logger.getLogger(SystemDeployerService.class);
    private BundleContext context;

    public SystemDeployerService(BundleContext context) {
        this.context = context;
    }

    @Override
    public void deploy(Deployment[] depArr) throws BundleException {
        DeploymentRegistryService registry = this.getDeploymentRegistry();
        ArrayList<Bundle> resolvableBundles = new ArrayList<Bundle>();
        HashMap<Deployment, Bundle> bundleMap = new HashMap<Deployment, Bundle>();
        for (Deployment dep : depArr) {
            log.debug((Object)("Install: " + dep.getLocation()));
            String location = dep.getLocation();
            Bundle bundle = this.context.installBundle(location);
            bundleMap.put(dep, bundle);
            if (dep.isAutoStart()) {
                resolvableBundles.add(bundle);
            }
            registry.registerDeployment(dep);
        }
        ServiceReference packageAdminRef = this.context.getServiceReference(PackageAdmin.class.getName());
        if (packageAdminRef != null && !resolvableBundles.isEmpty()) {
            PackageAdmin packageAdmin = (PackageAdmin)this.context.getService(packageAdminRef);
            Bundle[] resolvableBundleArr = new Bundle[resolvableBundles.size()];
            resolvableBundles.toArray(resolvableBundleArr);
            packageAdmin.resolveBundles(resolvableBundleArr);
        }
        for (Map.Entry entry : bundleMap.entrySet()) {
            int state;
            Deployment dep;
            dep = (Deployment)entry.getKey();
            Bundle bundle = (Bundle)entry.getValue();
            StartLevel startLevel = this.getStartLevel();
            Integer level = dep.getStartLevel();
            if (level != null && level > 0) {
                startLevel.setBundleStartLevel(bundle, level.intValue());
            }
            if (!dep.isAutoStart() || (state = bundle.getState()) != 4 && packageAdminRef != null) continue;
            try {
                log.debug((Object)("Start: " + bundle));
                bundle.start();
            }
            catch (BundleException ex) {
                log.error((Object)("Cannot start bundle: " + bundle), (Throwable)ex);
            }
        }
    }

    @Override
    public void undeploy(Deployment[] depArr) throws BundleException {
        DeploymentRegistryService registry = this.getDeploymentRegistry();
        for (Deployment dep : depArr) {
            Bundle bundle = this.getBundle(dep);
            if (bundle != null) {
                log.debug((Object)("Uninstall: " + bundle));
                registry.unregisterDeployment(dep);
                bundle.uninstall();
                continue;
            }
            log.warn((Object)("Cannot obtain bundle for: " + dep));
        }
    }

    private Bundle getBundle(Deployment dep) {
        String symbolicName = dep.getSymbolicName();
        Version version = Version.parseVersion((String)dep.getVersion());
        Bundle bundle = null;
        for (Bundle aux : this.context.getBundles()) {
            Version auxVersion;
            if (!aux.getSymbolicName().equals(symbolicName) || !version.equals((Object)(auxVersion = aux.getVersion()))) continue;
            bundle = aux;
            break;
        }
        return bundle;
    }

    private DeploymentRegistryService getDeploymentRegistry() {
        ServiceReference sref = this.context.getServiceReference(DeploymentRegistryService.class.getName());
        if (sref == null) {
            throw new IllegalStateException("Cannot obtain DeploymentRegistryService");
        }
        return (DeploymentRegistryService)this.context.getService(sref);
    }

    private StartLevel getStartLevel() {
        ServiceReference sref = this.context.getServiceReference(StartLevel.class.getName());
        return sref != null ? (StartLevel)this.context.getService(sref) : null;
    }
}

