/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment.internal;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.spi.util.AttachmentSupport;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Version;

public class DeploymentImpl
extends AttachmentSupport
implements Deployment,
Serializable {
    private static final long serialVersionUID = 6216977125749367927L;
    private transient VirtualFile rootFile;
    private URL rootURL;
    private Manifest manifest;
    private String location;
    private String symbolicName;
    private String version;
    private Integer startLevel;
    private boolean autoStart;
    private boolean update;

    public DeploymentImpl(VirtualFile rootFile, String location, String symbolicName, Version version) {
        if (rootFile == null) {
            throw new IllegalArgumentException("Null rootFile");
        }
        if (location == null) {
            location = rootFile.getPathName();
        }
        if (symbolicName == null) {
            symbolicName = rootFile.getName();
        }
        if (version == null) {
            version = Version.emptyVersion;
        }
        this.rootFile = rootFile;
        this.location = location;
        this.symbolicName = symbolicName;
        this.version = version.toString();
        try {
            this.rootURL = rootFile.toURL();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot obtain root URL", ex);
        }
    }

    @Override
    public VirtualFile getRoot() {
        if (this.rootFile == null) {
            try {
                this.rootFile = AbstractVFS.getRoot((URL)this.rootURL);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot obtain rootFile", ex);
            }
        }
        return this.rootFile;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getManifestHeader(String key) throws IOException {
        if (this.manifest == null) {
            try {
                this.manifest = VFSUtils.getManifest((VirtualFile)this.getRoot());
                if (this.manifest == null) {
                    throw new IOException("Cannot get manifest from: " + this.getRoot());
                }
            }
            catch (IOException ex) {
                throw new IOException("Cannot get manifest from: " + this.getRoot(), ex);
            }
        }
        Attributes atts = this.manifest.getMainAttributes();
        return atts.getValue(key);
    }

    @Override
    public Integer getStartLevel() {
        return this.startLevel;
    }

    @Override
    public void setStartLevel(Integer startLevel) {
        if (startLevel == null || startLevel < 1) {
            throw new IllegalArgumentException("Start level must be greater than one: " + startLevel);
        }
        this.startLevel = startLevel;
    }

    @Override
    public boolean isAutoStart() {
        return this.autoStart;
    }

    @Override
    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    @Override
    public boolean isBundleUpdate() {
        return this.update;
    }

    @Override
    public void setBundleUpdate(boolean update) {
        this.update = update;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeploymentImpl)) {
            return false;
        }
        DeploymentImpl other = (DeploymentImpl)obj;
        boolean matchLocation = this.getLocation().equals(other.getLocation());
        boolean matchName = this.getSymbolicName().equals(other.getSymbolicName());
        boolean matchVersion = this.getVersion().equals(other.getVersion());
        return matchLocation && matchName && matchVersion;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        String symbolicName = this.getSymbolicName();
        String version = this.getVersion();
        String location = this.getLocation();
        return "[" + symbolicName + "-" + version + ",location=" + location + "]";
    }
}

