/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.spi.framework;

//$Id: OSGiConfigurationProvider.java 84058 2009-02-10 14:02:01Z thomas.diesler@jboss.com $

import java.io.InputStream;
import java.net.URL;


/**
 * The ConfigurationProvider provides a Framework
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Jun-2008
 */
public interface OSGiConfigurationProvider
{
  /**
   * Get a Framework from this ConfigurationProvider
   * @return The configured instance of a Framework
   */
   OSGiFramework getFramework();
  
  /**
   * Get a Framework with a given name from this ConfigurationProvider
   * @return The configured instance of a Framework
   */
   OSGiFramework getFramework(String name);
  
  /**
   * Configure this provider from the given URL
   */
  void configure(URL urlConfig);
  
  /**
   * Configure this provider from the resource
   */
  void configure(String resourceConfig);
  
  /**
   * Configure this provider from the resource
   */
  void configure(InputStream streamConfig);
}