/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.spi.internal;

//$Id: MicrocontainerConfigurationProvider.java 84058 2009-02-10 14:02:01Z thomas.diesler@jboss.com $

import java.io.InputStream;
import java.net.URL;

import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.osgi.spi.NotImplementedException;
import org.jboss.osgi.spi.framework.OSGiConfigurationProvider;
import org.jboss.osgi.spi.framework.OSGiFramework;

/**
 * The ConfigurationProvider provides a Framework through a given configuration method
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Jun-2008
 */
public class MicrocontainerConfigurationProvider implements OSGiConfigurationProvider
{
  /* The Framework bean name - jboss.osgi:service=Framework */
  public static final String DEFAULT_BEAN_NAME = "jboss.osgi:service=Framework";
  /* The default bean config: jboss-osgi-beans.xml */
  public static final String DEFAULT_BEANS_CONFIG = "osgi-jboss-beans.xml";

  private Kernel kernel;
  
  public OSGiFramework getFramework()
  {
    return getFramework(DEFAULT_BEAN_NAME);
  }

  @SuppressWarnings("deprecation")
  public OSGiFramework getFramework(String beanName)
  {
    if (kernel == null)
      kernel = KernelLocator.getKernel();
    
    if (kernel == null)
      configure(DEFAULT_BEANS_CONFIG);
    
    KernelRegistryEntry entry = kernel.getRegistry().getEntry(beanName);
    OSGiFramework framework = (OSGiFramework)entry.getTarget();
    
    return framework;
  }

  public void configure(InputStream streamConfig)
  {
    throw new NotImplementedException("Cannot bootstrap JBossMC from InputStream");
  }

  public void configure(String resourceConfig)
  {
    URL urlConfig = Thread.currentThread().getContextClassLoader().getResource(resourceConfig);
    if (urlConfig == null)
      throw new IllegalStateException("Cannot find resource: " + resourceConfig);

    deploy(urlConfig);
  }

  public void configure(URL urlConfig)
  {
    deploy(urlConfig);
  }

  private void deploy(URL urlConfig)
  {
    EmbeddedBeansDeployer deployer = new EmbeddedBeansDeployer();
    deployer.deploy(urlConfig);
    kernel = deployer.getKernel();
    
    if (kernel == null)
      throw new IllegalStateException("Cannot obtain kernel, after beans deployment");
  }
}