/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.spi.junit;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * An OSGi Test Helper
 * 
 * @author Thomas.Diesler@jboss.org
 * @since 25-Sep-2008
 */
public class OSGiTestHelper
{
  private static final String SYSPROP_TEST_RESOURCES_DIRECTORY = "test.resources.directory";
  private static final String SYSPROP_TEST_ARCHIVE_DIRECTORY = "test.archive.directory";

  private static String testResourcesDir;
  private static String testArchiveDir;

  /** Try to discover the URL for the test resource */
  public URL getResourceURL(String resource) 
  {
    URL resURL = null;
    try
    {
      File resourceFile = getResourceFile(resource);
      resURL = resourceFile.toURI().toURL();
    }
    catch (MalformedURLException e)
    {
      // ignore
    }
    return resURL;
  }

  /** Try to discover the File for the test resource */
  public File getResourceFile(String resource)
  {
    File file = new File(resource);
    if (file.exists())
      return file;

    file = new File(getTestResourcesDir() + "/" + resource);
    if (file.exists())
      return file;

    throw new IllegalArgumentException("Cannot obtain '" + getTestResourcesDir() + "/" + resource + "'");
  }

  public String getTestResourcesDir()
  {
    if (testResourcesDir == null)
      testResourcesDir = System.getProperty(SYSPROP_TEST_RESOURCES_DIRECTORY, "target/test-classes");

    return testResourcesDir;
  }

  /** Try to discover the URL for the deployment archive */
  public URL getTestArchiveURL(String archive) throws MalformedURLException
  {
    return getTestArchiveFile(archive).toURI().toURL();
  }

  /** Try to discover the File for the deployment archive */
  public File getTestArchiveFile(String archive)
  {
    File file = new File(archive);
    if (file.exists())
      return file;
  
    file = new File(getTestArchiveDir() + "/" + archive);
    if (file.exists())
      return file;
  
    String notSet = (getTestArchiveDir() == null ? " System property '" + SYSPROP_TEST_ARCHIVE_DIRECTORY + "' not set." : "");
    throw new IllegalArgumentException("Cannot obtain '" + getTestArchiveDir() + "/" + archive + "'." + notSet);
  }

  public String getTestArchiveDir()
  {
    if (testArchiveDir == null)
      testArchiveDir = System.getProperty(SYSPROP_TEST_ARCHIVE_DIRECTORY, "target/test-libs");
  
    return testArchiveDir;
  }
}
