/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.internal;

import java.io.InputStream;
import java.net.URL;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.osgi.spi.NotImplementedException;
import org.jboss.osgi.spi.framework.OSGiConfigurationProvider;
import org.jboss.osgi.spi.framework.OSGiFramework;
import org.jboss.osgi.spi.internal.EmbeddedBeansDeployer;
import org.jboss.osgi.spi.internal.KernelLocator;

public class MicrocontainerConfigurationProvider
implements OSGiConfigurationProvider {
    public static final String DEFAULT_BEAN_NAME = "jboss.osgi:service=Framework";
    public static final String DEFAULT_BEANS_CONFIG = "osgi-jboss-beans.xml";
    private Kernel kernel;

    public OSGiFramework getFramework() {
        return this.getFramework(DEFAULT_BEAN_NAME);
    }

    public OSGiFramework getFramework(String beanName) {
        if (this.kernel == null) {
            this.kernel = KernelLocator.getKernel();
        }
        if (this.kernel == null) {
            this.configure(DEFAULT_BEANS_CONFIG);
        }
        KernelRegistryEntry entry = this.kernel.getRegistry().getEntry((Object)beanName);
        OSGiFramework framework = (OSGiFramework)entry.getTarget();
        return framework;
    }

    public void configure(InputStream streamConfig) {
        throw new NotImplementedException("Cannot bootstrap JBossMC from InputStream");
    }

    public void configure(String resourceConfig) {
        URL urlConfig = Thread.currentThread().getContextClassLoader().getResource(resourceConfig);
        if (urlConfig == null) {
            throw new IllegalStateException("Cannot find resource: " + resourceConfig);
        }
        this.deploy(urlConfig);
    }

    public void configure(URL urlConfig) {
        this.deploy(urlConfig);
    }

    private void deploy(URL urlConfig) {
        EmbeddedBeansDeployer deployer = new EmbeddedBeansDeployer();
        deployer.deploy(urlConfig);
        this.kernel = deployer.getKernel();
        if (this.kernel == null) {
            throw new IllegalStateException("Cannot obtain kernel, after beans deployment");
        }
    }
}

