/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.spi;

//$Id: Constants.java 87300 2009-04-14 17:26:54Z thomas.diesler@jboss.com $


/**
 * JBossOSGi Constants
 * 
 * @author thomas.diesler@jboss.com
 * @since 04-Mar-2009
 */
public interface Constants 
{
   /** The JBossOSGi domain 'jboss.osgi' */
   String DOMAIN_NAME = "jboss.osgi";
   
   /**
    * If set to 'true' bundles can be deployed in any order. Deployed bundle will get started when their dependencies can be resolved.
    * If set to 'false' bundles must be deployed in the order that is required to start them.
    * 
    * The default is 'true' 
    */
   String PROPERTY_DEFERRED_START = "org.jboss.osgi.deferred.start";
}
