/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.spi.framework;

// $Id: $

/**
 * Provide a named instance from the configuration.
 *
 * @author ales.justin@jboss.com
 * @author thomas.diesler@jboss.com
 */
public abstract class AbstractInstanceProvider implements NamedInstanceProvider
{
   public <T> T getInstance(String name, Class<T> expectedType)
   {
      if (name == null)
         throw new IllegalArgumentException("Null name");

      if (expectedType == null)
         throw new IllegalArgumentException("Null expected type.");

      Object attribute = getInstance(name);
      if (attribute != null)
      {
         if (expectedType.isInstance(attribute) == false)
            throw new IllegalArgumentException("Not of expected type [" + expectedType + "]: " + attribute);

         return expectedType.cast(attribute);
      }
      return null;
   }
}