/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.spi.framework;

//$Id: RemoteBundle.java 86975 2009-04-08 17:21:20Z thomas.diesler@jboss.com $

import org.osgi.framework.BundleException;

/**
 * The supported functionality of a remote OSGi Bundle.
 * 
 * @author thomas.diesler@jboss.com
 * @since 04-Mar-2009
 */
public interface RemoteBundle 
{
   /**
    * Returns this bundle's current state. 
    * A bundle can be in only one state at any time. 
    * 
    * @return An element of UNINSTALLED,INSTALLED, RESOLVED,STARTING, STOPPING,ACTIVE.
    */
   int getState();

   /**
    * Returns this bundle's unique identifier.
    */
   long getBundleId();
   
   /**
    * Returns the symbolic name of this bundle as specified by its Bundle-SymbolicName manifest header
    */
   String getSymbolicName();
   
   /**
    * Returns the value of the specified property from the BundleContext.
    */
   String getProperty(String key);
   
   /**
    * Starts this bundle with no options
    */
   void start() throws BundleException;
   
   /**
    * Stops this bundle with no options.
    */
   void stop() throws BundleException;
}