/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.spi.internal;

//$Id: MicrocontainerBootstrapProvider.java 85162 2009-03-03 13:08:22Z thomas.diesler@jboss.com $

import java.io.InputStream;
import java.net.URL;

import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.plugins.bootstrap.basic.KernelConstants;
import org.jboss.osgi.spi.NotImplementedException;
import org.jboss.osgi.spi.framework.AbstractInstanceProvider;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.framework.OSGiFramework;

/**
 * Bootstrap the OSGiFrameworj through the MC
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Jun-2008
 */
public class MicrocontainerBootstrapProvider extends AbstractInstanceProvider implements OSGiBootstrapProvider
{
   private EmbeddedBeansDeployer deployer = new EmbeddedBeansDeployer();
   private boolean bootstraped;
   private boolean configured;

   public OSGiFramework getFramework()
   {
      return getFramework(DEFAULT_FRAMEWORK_NAME);
   }

   public OSGiFramework getFramework(String beanName)
   {
      OSGiFramework framework = getInstance(beanName, OSGiFramework.class);
      if (framework == null && configured == false)
      {
         configure(DEFAULT_FRAMEWORK_BEANS);
         framework = getInstance(beanName, OSGiFramework.class);
      }
      return framework;
   }

   public void configure()
   {
      configure(DEFAULT_FRAMEWORK_BEANS);
   }

   public void configure(InputStream streamConfig)
   {
      throw new NotImplementedException("Cannot bootstrap JBossMC from InputStream");
   }

   public void configure(String resourceConfig)
   {
      URL urlConfig = Thread.currentThread().getContextClassLoader().getResource(resourceConfig);
      if (urlConfig == null)
         throw new IllegalStateException("Cannot find resource: " + resourceConfig);

      configure(urlConfig);
   }

   public void configure(URL urlConfig)
   {
      deployer.deploy(urlConfig);
      configured = true;
   }

   public Object getInstance(String name)
   {
      Object retObj = null;

      if (bootstraped == false)
      {
         bootstrapKernel();
         bootstraped = true;
      }

      if (KernelConstants.KERNEL_NAME.equals(name))
      {
         retObj = deployer.getKernel();
      }
      else
      {
         Controller controller = deployer.getKernel().getController();
         ControllerContext context = controller.getInstalledContext(name);
         if (context != null)
            retObj = context.getTarget();
      }

      return retObj;
   }

   private void bootstrapKernel()
   {
      // Deploy the bootstrap beans if DEFAULT_BOOTSTRAP_BEANS is on the classpath
      URL urlBootstrap = Thread.currentThread().getContextClassLoader().getResource(DEFAULT_BOOTSTRAP_BEANS);
      if (urlBootstrap != null)
         deployer.deploy(urlBootstrap);
   }
}