/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.spi.junit;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.virtual.VFS;

/**
 * An archive deployer that deals with test deployment/undeployment, etc.
 * 
 * @author Thomas.Diesler@jboss.org
 * @since 26-Feb-2009
 */
public class EmbeddedArchiveDeployer implements ArchiveDeployer
{
   private DeployerClient deployer;
   private Map<String, VFSDeployment> deployments = new HashMap<String, VFSDeployment>();

   public EmbeddedArchiveDeployer(DeployerClient deployer)
   {
      if (deployer == null)
         throw new IllegalArgumentException("Cannot construct archive deployer with: " + deployer);
      
      this.deployer = deployer;
   }

   public void deploy(URL url) throws Exception
   {
      VFSDeploymentFactory factory = VFSDeploymentFactory.getInstance();
      VFSDeployment deployment = factory.createVFSDeployment(VFS.getRoot(url));
      deployer.deploy(deployment);
      deployments.put(url.toExternalForm(), deployment);
   }

   public void undeploy(URL url) throws Exception
   {
      VFSDeployment deployment = deployments.remove(url.toExternalForm());
      if (deployment != null)
         deployer.undeploy(deployment);
   }
}
