/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.spi.junit;

// $Id: IntegrationTest.java 87424 2009-04-16 13:30:52Z thomas.diesler@jboss.com $

import java.net.URL;

import javax.management.MBeanServerConnection;

import org.jboss.osgi.spi.framework.RemoteBundle;
import org.jboss.osgi.spi.framework.RemoteFramework;
import org.jboss.osgi.spi.logging.LogEntryCache;

/**
 * An integration test case
 * 
 * @author Thomas.Diesler@jboss.org
 * @since 25-Sep-2008
 */
public abstract class IntegrationTest extends OSGiTest
{
   private IntegrationTestHelper delegate;

   private IntegrationTestHelper getDelegate()
   {
      if (delegate == null)
      {
         delegate = new IntegrationTestHelper(getBootstrapProvider());
      }
      return delegate;
   }

   protected void startRemoteLogEntryTracking(LogEntryCache entryCache) throws Exception
   {
      getDelegate().startRemoteLogEntryTracking(entryCache);
   }
   
   protected void stopRemoteLogEntryTracking() throws Exception
   {
      getDelegate().stopRemoteLogEntryTracking();
   }
   
   protected boolean isRemoteIntegration()
   {
      return IntegrationTestHelper.isRemoteIntegration();
   }

   protected boolean isTargetJBoss50()
   {
      return getDelegate().isTargetJBoss50();
   }

   protected RemoteBundle deployBundle(String archive) throws Exception
   {
      return getDelegate().deployBundle(archive);
   }
   
   protected void undeployBundle(String archive) throws Exception
   {
      getDelegate().undeployBundle(archive);
   }

   protected void deploy(String archive) throws Exception
   {
      getDelegate().deploy(archive);
   }

   protected void deploy(URL archive) throws Exception
   {
      getDelegate().deploy(archive);
   }

   protected void undeploy(String archive) throws Exception
   {
      getDelegate().undeploy(archive);
   }

   protected void undeploy(URL archive) throws Exception
   {
      getDelegate().undeploy(archive);
   }

   protected RemoteFramework getRemoteFramework() throws Exception
   {
      return getDelegate().getRemoteFramework();
   }
   
   protected MBeanServerConnection getServer()
   {
      return getDelegate().getServer();
   }

   protected String getServerHost()
   {
      return getDelegate().getServerHost();
   }
}
