/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.spi.junit;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import junit.framework.TestCase;

import org.jboss.logging.Logger;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.logging.LogEntryCache;
import org.jboss.virtual.VFS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

/**
 * An OSGi Test Case
 * 
 * @author Thomas.Diesler@jboss.org
 * @since 25-Sep-2008
 */
public abstract class OSGiTest extends TestCase
{
   // Provide logging
   final Logger log = Logger.getLogger(OSGiTest.class);

   private OSGiTestHelper delegate = new OSGiTestHelper();

   public OSGiTest()
   {
      // Prevent unknown protocol: vfsfile
      VFS.init();
   }

   private OSGiTestHelper getDelegate()
   {
      if (delegate == null)
      {
         delegate = new OSGiTestHelper();
      }
      return delegate;
   }

   protected OSGiBootstrapProvider createBootstrapProvider()
   {
      return delegate.createBootstrapProvider();
   }

   protected OSGiBootstrapProvider getBootstrapProvider()
   {
      return delegate.getBootstrapProvider();
   }

   protected void setBootstrapProvider(OSGiBootstrapProvider bootProvider)
   {
      delegate.setBootstrapProvider(bootProvider);
   }

   protected void startLogEntryTracking(LogEntryCache entryCache) throws Exception
   {
      getDelegate().startLogEntryTracking(entryCache);
   }
   
   protected void stopLogEntryTracking() throws Exception
   {
      getDelegate().stopLogEntryTracking();
   }
   
   @Override
   protected void setUp() throws Exception
   {
      log.debug("### START " + getLongName());
      super.setUp();
   }

   @Override
   protected void tearDown() throws Exception
   {
      super.tearDown();
      log.debug("### END " + getLongName());
   }

   protected String getShortName()
   {
      String shortName = getClass().getName();
      shortName = shortName.substring(shortName.lastIndexOf(".") + 1);
      return shortName;
   }

   protected String getLongName()
   {
      return getClass().getName() + "." + getName();
   }

   protected URL getResourceURL(String resource)
   {
      return delegate.getResourceURL(resource);
   }

   protected File getResourceFile(String resource)
   {
      return delegate.getResourceFile(resource);
   }

   protected File getTestArchiveFile(String archive)
   {
      return delegate.getTestArchiveFile(archive);
   }

   protected URL getTestArchiveURL(String archive) throws MalformedURLException
   {
      return delegate.getTestArchiveFile(archive).toURI().toURL();
   }

   protected Bundle installBundle(BundleContext sysContext, String bundlePath, boolean start) throws BundleException
   {
      return delegate.installBundle(sysContext, bundlePath, start);
   }
}
