/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.spi.management;

//$Id: ManagedFramework.java 85234 2009-03-04 16:04:36Z thomas.diesler@jboss.com $

import java.util.Set;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;

import org.jboss.logging.Logger;
import org.jboss.osgi.spi.Constants;

/**
 * The managed view of an OSGi Framework
 * 
 * @author thomas.diesler@jboss.com
 * @since 04-Mar-2009
 */
public class ManagedFramework implements ManagedFrameworkMBean
{
   // Provide logging
   final Logger log = Logger.getLogger(ManagedFramework.class);

   private MBeanServer mbeanServer;

   public void setMbeanServer(MBeanServer server)
   {
      this.mbeanServer = server;
   }

   @SuppressWarnings("unchecked")
   public ObjectName getBundle(String symbolicName)
   {
      ObjectName pattern = ObjectNameFactory.create(Constants.DOMAIN_NAME + ":bundle=" + symbolicName + ",*");
      Set<ObjectName> names = mbeanServer.queryNames(pattern, null);
      
      if (names.size() < 1)
         return null;

      if (names.size() > 1)
         throw new IllegalArgumentException("Multiple bundles found: " + names);

      return names.iterator().next();
   }

   @SuppressWarnings("unchecked")
   public Set<ObjectName> getBundles()
   {
      // [JBAS-6571] JMX filtering does not work with wildcards
      // ObjectName pattern = ObjectNameFactory.create(Constants.DOMAIN_NAME + ":bundle=*,*");
      // Set<ObjectName> names = mbeanServer.queryNames(pattern, null);
      
      ObjectName pattern = ObjectNameFactory.create(Constants.DOMAIN_NAME + ":*");
      Set<ObjectName> names = mbeanServer.queryNames(pattern, new IsBundleQueryExp());
      return names;
   }

   // Accept names like "jboss.osgi:bundle=*"
   static class IsBundleQueryExp implements QueryExp
   {
      private static final long serialVersionUID = 1L;

      public boolean apply(ObjectName name)
      {
         return name.getKeyProperty("bundle") != null;
      }

      public void setMBeanServer(MBeanServer server)
      {
      }
   }

   public void start()
   {
      try
      {
         if (mbeanServer != null)
            mbeanServer.registerMBean(this, ManagedFrameworkMBean.OBJECT_NAME);
      }
      catch (Exception ex)
      {
         log.warn("Cannot register: " + ManagedFrameworkMBean.OBJECT_NAME);
      }
   }
}