/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.spi.service.microcontainer.internal;

//$Id: MicrocontainerServiceImpl.java 87613 2009-04-21 09:33:42Z thomas.diesler@jboss.com $

import javax.management.MBeanServer;

import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.Kernel;
import org.jboss.osgi.spi.service.microcontainer.MicrocontainerService;
import org.osgi.framework.BundleContext;

/**
 * An OSGi Service the gives access to the Kernel and MBeanServer.
 * 
 * @author thomas.diesler@jboss.com
 * @since 23-Jan-2009
 */
public class MicrocontainerServiceImpl implements MicrocontainerService
{
  private BundleContext systemContext;
  private MBeanServer mbeanServer;
  private Kernel kernel;

  /**
   *  Register this bean as an OSGi service
   */
  public void create()
  {
    systemContext.registerService(MicrocontainerService.class.getName(), this, null);
  }
  
  public void setSystemContext(BundleContext bundleContext)
  {
    this.systemContext = bundleContext;
  }

  public void setKernel(Kernel kernel)
  {
    this.kernel = kernel;
  }

  public Kernel getKernel()
  {
    return kernel;
  }

  public MBeanServer getMbeanServer()
  {
    return mbeanServer;
  }

  public void setMbeanServer(MBeanServer server)
  {
    this.mbeanServer = server;
  }

  public Object getRegisteredBean(String beanName)
  {
    if (kernel == null)
      throw new IllegalArgumentException("Kernel cannot be null");

    ControllerContext context = kernel.getController().getInstalledContext(beanName);
    return context.getTarget();
  }
}