/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.framework;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;

public final class OSGiBootstrap {
    private OSGiBootstrap() {
    }

    public static OSGiBootstrapProvider getBootstrapProvider() {
        OSGiBootstrapProvider provider;
        ClassLoader ctxLoader;
        String providerName = System.getProperty(OSGiBootstrapProvider.class.getName());
        if (providerName == null) {
            ctxLoader = Thread.currentThread().getContextClassLoader();
            URL providerURL = ctxLoader.getResource(OSGiBootstrapProvider.class.getName());
            if (providerURL == null) {
                throw new IllegalStateException("Cannot find resource: " + OSGiBootstrapProvider.class.getName());
            }
            try {
                providerName = new BufferedReader(new InputStreamReader(providerURL.openStream())).readLine();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot read bootstrap provider name from: " + providerURL);
            }
        }
        if (providerName == null) {
            throw new IllegalStateException("Cannot obtain bootstrap provider");
        }
        try {
            ctxLoader = Thread.currentThread().getContextClassLoader();
            Class<?> providerClass = ctxLoader.loadClass(providerName);
            provider = (OSGiBootstrapProvider)providerClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load bootstrap provider: " + providerName);
        }
        return provider;
    }
}

