/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.internal;

import java.io.InputStream;
import java.net.URL;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.osgi.spi.NotImplementedException;
import org.jboss.osgi.spi.framework.AbstractInstanceProvider;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.framework.OSGiFramework;
import org.jboss.osgi.spi.internal.EmbeddedBeansDeployer;

public class MicrocontainerBootstrapProvider
extends AbstractInstanceProvider
implements OSGiBootstrapProvider {
    private EmbeddedBeansDeployer deployer = new EmbeddedBeansDeployer();
    private boolean bootstraped;
    private boolean configured;

    public OSGiFramework getFramework() {
        return this.getFramework("jboss.osgi:service=Framework");
    }

    public OSGiFramework getFramework(String beanName) {
        OSGiFramework framework = this.getInstance(beanName, OSGiFramework.class);
        if (framework == null && !this.configured) {
            this.configure("jboss-osgi-beans.xml");
            framework = this.getInstance(beanName, OSGiFramework.class);
        }
        return framework;
    }

    public void configure() {
        this.configure("jboss-osgi-beans.xml");
    }

    public void configure(InputStream streamConfig) {
        throw new NotImplementedException("Cannot bootstrap JBossMC from InputStream");
    }

    public void configure(String resourceConfig) {
        URL urlConfig = Thread.currentThread().getContextClassLoader().getResource(resourceConfig);
        if (urlConfig == null) {
            throw new IllegalStateException("Cannot find resource: " + resourceConfig);
        }
        this.configure(urlConfig);
    }

    public void configure(URL urlConfig) {
        this.deployer.deploy(urlConfig);
        this.configured = true;
    }

    public Object getInstance(String name) {
        Object retObj = null;
        if (!this.bootstraped) {
            this.bootstrapKernel();
            this.bootstraped = true;
        }
        if ("jboss.kernel:service=Kernel".equals(name)) {
            retObj = this.deployer.getKernel();
        } else {
            KernelController controller = this.deployer.getKernel().getController();
            ControllerContext context = controller.getInstalledContext((Object)name);
            if (context != null) {
                retObj = context.getTarget();
            }
        }
        return retObj;
    }

    private void bootstrapKernel() {
        URL urlBootstrap = Thread.currentThread().getContextClassLoader().getResource("jboss-osgi-bootstrap-beans.xml");
        if (urlBootstrap != null) {
            this.deployer.deploy(urlBootstrap);
        }
    }
}

