/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.junit;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.osgi.spi.junit.ArchiveDeployer;
import org.jboss.virtual.VFS;

public class EmbeddedArchiveDeployer
implements ArchiveDeployer {
    private DeployerClient deployer;
    private Map<String, VFSDeployment> deployments = new HashMap<String, VFSDeployment>();

    public EmbeddedArchiveDeployer(DeployerClient deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Cannot construct archive deployer with: " + deployer);
        }
        this.deployer = deployer;
    }

    public void deploy(URL url) throws Exception {
        VFSDeploymentFactory factory = VFSDeploymentFactory.getInstance();
        VFSDeployment deployment = factory.createVFSDeployment(VFS.getRoot((URL)url));
        this.deployer.deploy(new Deployment[]{deployment});
        this.deployments.put(url.toExternalForm(), deployment);
    }

    public void undeploy(URL url) throws Exception {
        VFSDeployment deployment = this.deployments.remove(url.toExternalForm());
        if (deployment != null) {
            this.deployer.undeploy(new Deployment[]{deployment});
        }
    }
}

