/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.junit;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.framework.OSGiFramework;
import org.jboss.osgi.spi.framework.RemoteBundle;
import org.jboss.osgi.spi.framework.RemoteFramework;
import org.jboss.osgi.spi.framework.RemoteFrameworkException;
import org.jboss.osgi.spi.junit.ArchiveDeployer;
import org.jboss.osgi.spi.junit.EmbeddedArchiveDeployer;
import org.jboss.osgi.spi.junit.OSGiTestHelper;
import org.jboss.osgi.spi.junit.RemoteArchiveDeployer;
import org.jboss.osgi.spi.logging.LogEntryCache;
import org.jboss.osgi.spi.logging.RemoteLogReaderService;
import org.jboss.osgi.spi.management.MBeanProxy;
import org.jboss.osgi.spi.management.MBeanProxyException;
import org.jboss.osgi.spi.management.ManagedBundleMBean;
import org.jboss.osgi.spi.management.ManagedFrameworkMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.util.tracker.ServiceTracker;

public class IntegrationTestHelper
extends OSGiTestHelper {
    private static MBeanServerConnection server;
    private ManagedFrameworkMBean managedFramework;
    private String integrationTarget;

    public IntegrationTestHelper(OSGiBootstrapProvider bootProvider) {
        this.setBootstrapProvider(bootProvider);
    }

    protected void startRemoteLogEntryTracking(final LogEntryCache logEntryCache) throws Exception {
        OSGiFramework framework = this.getBootstrapProvider().getFramework();
        BundleContext sysContext = framework.getSystemBundleContext();
        ServiceTracker tracker = new ServiceTracker(sysContext, RemoteLogReaderService.class.getName(), null){

            public Object addingService(ServiceReference sref) {
                LogReaderService service = (LogReaderService)super.addingService(sref);
                service.addLogListener((LogListener)logEntryCache);
                return service;
            }
        };
        tracker.open();
        this.installBundle(sysContext, "bundles/jboss-osgi-remotelog.jar", true);
        this.deployBundle("bundles/jboss-osgi-remotelog.jar");
    }

    protected void stopRemoteLogEntryTracking() throws Exception {
        this.undeployBundle("bundles/jboss-osgi-remotelog.jar");
    }

    public void deploy(String archive) throws Exception {
        URL url = this.getTestArchiveFile(archive).toURI().toURL();
        this.deploy(url);
    }

    public void deploy(URL archive) throws Exception {
        this.getDeployer().deploy(archive);
    }

    public void undeploy(String archive) throws Exception {
        URL url = this.getTestArchiveFile(archive).toURI().toURL();
        this.undeploy(url);
    }

    public void undeploy(URL archive) throws Exception {
        this.getDeployer().undeploy(archive);
    }

    public boolean isTargetJBoss50() {
        String target = this.getIntegrationTarget();
        return target.startsWith("jboss50");
    }

    private String getIntegrationTarget() {
        if (this.integrationTarget == null) {
            String jbossVersion;
            try {
                ObjectName oname = new ObjectName("jboss.system:type=ServerConfig");
                jbossVersion = (String)this.getServer().getAttribute(oname, "SpecificationVersion");
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot obtain jboss version", ex);
            }
            if (jbossVersion.startsWith("5.0")) {
                this.integrationTarget = "jboss50";
            } else {
                throw new IllegalStateException("Unsupported jboss version: " + jbossVersion);
            }
        }
        return this.integrationTarget;
    }

    public MBeanServerConnection getServer() {
        if (server == null) {
            Hashtable<?, ?> jndiEnv = null;
            try {
                InitialContext iniCtx = new InitialContext();
                jndiEnv = iniCtx.getEnvironment();
                server = (MBeanServerConnection)iniCtx.lookup("jmx/invoker/RMIAdaptor");
            }
            catch (NamingException ex) {
                throw new RuntimeException("Cannot obtain MBeanServerConnection using jndi props: " + jndiEnv, ex);
            }
        }
        return server;
    }

    private ArchiveDeployer getDeployer() {
        if (IntegrationTestHelper.isRemoteIntegration()) {
            return new RemoteArchiveDeployer(this.getServer());
        }
        DeployerClient deployer = (DeployerClient)this.getBootstrapProvider().getInstance("MainDeployer");
        return new EmbeddedArchiveDeployer(deployer);
    }

    public RemoteBundle deployBundle(String archive) throws Exception {
        File archiveFile = this.getTestArchiveFile(archive);
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(archiveFile));
        Attributes attribs = jarInputStream.getManifest().getMainAttributes();
        String symbolicName = attribs.getValue("Bundle-SymbolicName");
        jarInputStream.close();
        if (symbolicName == null) {
            throw new IllegalArgumentException("Cannot obtain Bundle-SymbolicName for: " + archive);
        }
        this.deploy(archive);
        return this.getRemoteFramework().getBundle(symbolicName);
    }

    public void undeployBundle(String archive) throws Exception {
        this.undeploy(archive);
    }

    public RemoteFramework getRemoteFramework() throws Exception {
        if (this.managedFramework == null) {
            this.managedFramework = MBeanProxy.get(ManagedFrameworkMBean.class, ManagedFrameworkMBean.OBJECT_NAME, this.getServer());
        }
        return new RemoteFramework(){

            @Override
            public RemoteBundle getBundle(String symbolicName) {
                ObjectName bundleOName = IntegrationTestHelper.this.managedFramework.getBundle(symbolicName);
                try {
                    return MBeanProxy.get(ManagedBundleMBean.class, bundleOName, IntegrationTestHelper.this.getServer());
                }
                catch (MBeanProxyException ex) {
                    throw new RemoteFrameworkException(ex);
                }
            }

            @Override
            public Set<RemoteBundle> getBundles() {
                HashSet<RemoteBundle> remBundles = new HashSet<RemoteBundle>();
                for (ObjectName bundleOName : IntegrationTestHelper.this.managedFramework.getBundles()) {
                    try {
                        RemoteBundle remBundle = MBeanProxy.get(ManagedBundleMBean.class, bundleOName, IntegrationTestHelper.this.getServer());
                        remBundles.add(remBundle);
                    }
                    catch (MBeanProxyException ex) {
                        throw new RemoteFrameworkException(ex);
                    }
                }
                return remBundles;
            }
        };
    }

    public static boolean isRemoteIntegration() {
        return System.getProperty("jboss.bind.address") != null;
    }

    public String getServerHost() {
        return System.getProperty("jboss.bind.address", "localhost");
    }
}

