/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.junit;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;
import org.jboss.osgi.spi.junit.IntegrationTestHelper;
import org.jboss.osgi.spi.junit.OSGiTestSetup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrationTestSetup
extends OSGiTestSetup {
    private IntegrationTestHelper delegate;
    private String[] archives = new String[0];
    private ClassLoader originalClassLoader;

    public IntegrationTestSetup(Class<?> testClass, String archiveList) {
        super(testClass);
        this.getArchiveArray(archiveList);
    }

    private IntegrationTestHelper getDelegate() {
        if (this.delegate == null) {
            this.delegate = new IntegrationTestHelper(this.getBootstrapProvider());
        }
        return this.delegate;
    }

    public File getArchiveFile(String archive) {
        return this.getDelegate().getTestArchiveFile(archive);
    }

    public URL getArchiveURL(String archive) throws MalformedURLException {
        return this.getDelegate().getTestArchiveFile(archive).toURI().toURL();
    }

    public boolean isRemoteIntegration() {
        return IntegrationTestHelper.isRemoteIntegration();
    }

    public boolean isTargetJBoss50() {
        return this.getDelegate().isTargetJBoss50();
    }

    public MBeanServerConnection getServer() {
        return this.getDelegate().getServer();
    }

    public String getServerHost() {
        return this.getDelegate().getServerHost();
    }

    private void getArchiveArray(String archiveList) {
        if (archiveList != null) {
            StringTokenizer st = new StringTokenizer(archiveList, ", ");
            this.archives = new String[st.countTokens()];
            for (int i = 0; i < this.archives.length; ++i) {
                this.archives[i] = st.nextToken();
            }
        }
    }

    @Override
    protected void setUp() throws Exception {
        ClassLoader parent;
        super.setUp();
        ArrayList<URL> clientJars = new ArrayList<URL>();
        for (int i = 0; i < this.archives.length; ++i) {
            String archive = this.archives[i];
            try {
                this.getDelegate().deploy(archive);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.getDelegate().undeploy(archive);
            }
            if (!archive.endsWith("-client.jar")) continue;
            URL archiveURL = this.getArchiveURL(archive);
            clientJars.add(archiveURL);
        }
        this.originalClassLoader = parent = Thread.currentThread().getContextClassLoader();
        if (!clientJars.isEmpty()) {
            URL[] urls = new URL[clientJars.size()];
            for (int i = 0; i < clientJars.size(); ++i) {
                urls[i] = (URL)clientJars.get(i);
            }
            URLClassLoader cl = new URLClassLoader(urls, parent);
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            for (int i = 0; i < this.archives.length; ++i) {
                String archive = this.archives[this.archives.length - i - 1];
                this.getDelegate().undeploy(archive);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        }
        super.tearDown();
    }
}

