/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.junit;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.TestCase;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.junit.OSGiTestHelper;
import org.jboss.osgi.spi.logging.LogEntryCache;
import org.jboss.virtual.VFS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public abstract class OSGiTest
extends TestCase {
    final Logger log = Logger.getLogger(OSGiTest.class);
    private OSGiTestHelper delegate = new OSGiTestHelper();

    public OSGiTest() {
        VFS.init();
    }

    private OSGiTestHelper getDelegate() {
        if (this.delegate == null) {
            this.delegate = new OSGiTestHelper();
        }
        return this.delegate;
    }

    protected OSGiBootstrapProvider createBootstrapProvider() {
        return this.delegate.createBootstrapProvider();
    }

    protected OSGiBootstrapProvider getBootstrapProvider() {
        return this.delegate.getBootstrapProvider();
    }

    protected void setBootstrapProvider(OSGiBootstrapProvider bootProvider) {
        this.delegate.setBootstrapProvider(bootProvider);
    }

    protected void startLogEntryTracking(LogEntryCache entryCache) throws Exception {
        this.getDelegate().startLogEntryTracking(entryCache);
    }

    protected void stopLogEntryTracking() throws Exception {
        this.getDelegate().stopLogEntryTracking();
    }

    protected void setUp() throws Exception {
        this.log.debug((Object)("### START " + this.getLongName()));
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.log.debug((Object)("### END " + this.getLongName()));
    }

    protected String getShortName() {
        String shortName = ((Object)((Object)this)).getClass().getName();
        shortName = shortName.substring(shortName.lastIndexOf(".") + 1);
        return shortName;
    }

    protected String getLongName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }

    protected URL getResourceURL(String resource) {
        return this.delegate.getResourceURL(resource);
    }

    protected File getResourceFile(String resource) {
        return this.delegate.getResourceFile(resource);
    }

    protected File getTestArchiveFile(String archive) {
        return this.delegate.getTestArchiveFile(archive);
    }

    protected URL getTestArchiveURL(String archive) throws MalformedURLException {
        return this.delegate.getTestArchiveFile(archive).toURI().toURL();
    }

    protected Bundle installBundle(BundleContext sysContext, String bundlePath, boolean start) throws BundleException {
        return this.delegate.installBundle(sysContext, bundlePath, start);
    }
}

