/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.junit;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.osgi.spi.framework.OSGiBootstrap;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.framework.OSGiFramework;
import org.jboss.osgi.spi.logging.LogEntryCache;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.util.tracker.ServiceTracker;

public class OSGiTestHelper {
    private static final String SYSPROP_TEST_RESOURCES_DIRECTORY = "test.resources.directory";
    private static final String SYSPROP_TEST_ARCHIVE_DIRECTORY = "test.archive.directory";
    private OSGiBootstrapProvider bootProvider;
    private static String testResourcesDir;
    private static String testArchiveDir;

    public OSGiBootstrapProvider createBootstrapProvider() {
        return OSGiBootstrap.getBootstrapProvider();
    }

    public OSGiBootstrapProvider getBootstrapProvider() {
        if (this.bootProvider == null) {
            this.bootProvider = this.createBootstrapProvider();
        }
        return this.bootProvider;
    }

    public void setBootstrapProvider(OSGiBootstrapProvider bootProvider) {
        this.bootProvider = bootProvider;
    }

    protected void startLogEntryTracking(final LogEntryCache logEntryCache) throws Exception {
        OSGiFramework framework = this.getBootstrapProvider().getFramework();
        BundleContext sysContext = framework.getSystemBundleContext();
        ServiceTracker tracker = new ServiceTracker(sysContext, LogReaderService.class.getName(), null){

            public Object addingService(ServiceReference sref) {
                LogReaderService service = (LogReaderService)super.addingService(sref);
                service.addLogListener((LogListener)logEntryCache);
                return service;
            }
        };
        tracker.open();
    }

    protected void stopLogEntryTracking() throws Exception {
    }

    public URL getResourceURL(String resource) {
        URL resURL = null;
        try {
            File resourceFile = this.getResourceFile(resource);
            resURL = resourceFile.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return resURL;
    }

    public File getResourceFile(String resource) {
        File file = new File(resource);
        if (file.exists()) {
            return file;
        }
        file = new File(this.getTestResourcesDir() + "/" + resource);
        if (file.exists()) {
            return file;
        }
        throw new IllegalArgumentException("Cannot obtain '" + this.getTestResourcesDir() + "/" + resource + "'");
    }

    public String getTestResourcesDir() {
        if (testResourcesDir == null) {
            testResourcesDir = System.getProperty(SYSPROP_TEST_RESOURCES_DIRECTORY, "target/test-classes");
        }
        return testResourcesDir;
    }

    public URL getTestArchiveURL(String archive) {
        try {
            return this.getTestArchiveFile(archive).toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public File getTestArchiveFile(String archive) {
        File file = new File(archive);
        if (file.exists()) {
            return file;
        }
        file = new File(this.getTestArchiveDir() + "/" + archive);
        if (file.exists()) {
            return file;
        }
        String notSet = this.getTestArchiveDir() == null ? " System property 'test.archive.directory' not set." : "";
        throw new IllegalArgumentException("Cannot obtain '" + this.getTestArchiveDir() + "/" + archive + "'." + notSet);
    }

    public String getTestArchiveDir() {
        if (testArchiveDir == null) {
            testArchiveDir = System.getProperty(SYSPROP_TEST_ARCHIVE_DIRECTORY, "target/test-libs");
        }
        return testArchiveDir;
    }

    public Bundle installBundle(BundleContext sysContext, String bundlePath, boolean start) throws BundleException {
        Bundle bundle = sysContext.installBundle(this.getTestArchiveURL(bundlePath).toExternalForm());
        if (start) {
            bundle.start();
        }
        return bundle;
    }
}

