/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.junit;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.framework.OSGiBootstrap;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.junit.OSGiTestHelper;
import org.jboss.virtual.VFS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiTestSetup
extends TestSetup {
    final Logger log = Logger.getLogger(OSGiTestSetup.class);
    private OSGiTestHelper delegate = new OSGiTestHelper();
    private OSGiBootstrapProvider bootProvider;

    public OSGiTestSetup(Class<?> testCase) {
        super((Test)new TestSuite(new Class[]{testCase}));
        VFS.init();
    }

    public OSGiBootstrapProvider createBootstrapProvider() {
        return OSGiBootstrap.getBootstrapProvider();
    }

    public OSGiBootstrapProvider getBootstrapProvider() {
        if (this.bootProvider == null) {
            this.bootProvider = this.createBootstrapProvider();
        }
        return this.bootProvider;
    }

    public void setBootstrapProvider(OSGiBootstrapProvider bootProvider) {
        this.bootProvider = bootProvider;
    }

    protected void setUp() throws Exception {
        this.log.debug((Object)("### START SETUP " + this.getTest()));
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.log.debug((Object)("### END SETUP " + this.getTest()));
    }

    protected URL getResourceURL(String resource) {
        return this.delegate.getResourceURL(resource);
    }

    protected File getResourceFile(String resource) {
        return this.delegate.getResourceFile(resource);
    }

    public File getTestArchiveFile(String archive) {
        return this.delegate.getTestArchiveFile(archive);
    }

    public URL getTestArchiveURL(String archive) throws MalformedURLException {
        return this.delegate.getTestArchiveFile(archive).toURI().toURL();
    }
}

