/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.management.ManagedFrameworkMBean;
import org.jboss.osgi.spi.management.ObjectNameFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedFramework
implements ManagedFrameworkMBean {
    final Logger log = Logger.getLogger(ManagedFramework.class);
    private MBeanServer mbeanServer;

    public void setMbeanServer(MBeanServer server) {
        this.mbeanServer = server;
    }

    @Override
    public ObjectName getBundle(String symbolicName) {
        ObjectName pattern = ObjectNameFactory.create("jboss.osgi:bundle=" + symbolicName + ",*");
        Set<ObjectName> names = this.mbeanServer.queryNames(pattern, null);
        if (names.size() < 1) {
            return null;
        }
        if (names.size() > 1) {
            throw new IllegalArgumentException("Multiple bundles found: " + names);
        }
        return names.iterator().next();
    }

    @Override
    public Set<ObjectName> getBundles() {
        ObjectName pattern = ObjectNameFactory.create("jboss.osgi:*");
        Set<ObjectName> names = this.mbeanServer.queryNames(pattern, new IsBundleQueryExp());
        return names;
    }

    public void start() {
        try {
            if (this.mbeanServer != null) {
                this.mbeanServer.registerMBean(this, ManagedFrameworkMBean.OBJECT_NAME);
            }
        }
        catch (Exception ex) {
            this.log.warn((Object)("Cannot register: " + ManagedFrameworkMBean.OBJECT_NAME));
        }
    }

    static class IsBundleQueryExp
    implements QueryExp {
        private static final long serialVersionUID = 1L;

        IsBundleQueryExp() {
        }

        public boolean apply(ObjectName name) {
            return name.getKeyProperty("bundle") != null;
        }

        public void setMBeanServer(MBeanServer server) {
        }
    }
}

