/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.framework;

import java.io.InputStream;
import java.net.URL;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.osgi.spi.NotImplementedException;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.framework.OSGiFramework;
import org.jboss.osgi.spi.internal.EmbeddedBeansDeployer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicrocontainerBootstrapProvider
implements OSGiBootstrapProvider {
    public static final String OSGI_BOOTSTRAP_BEANS = "jboss.osgi.bootstrap.beans";
    public static final String DEFAULT_OSGI_BOOTSTRAP_XML = "jboss-osgi-bootstrap-beans.xml";
    public static final String OSGI_FRAMEWORK_BEANS = "jboss.osgi.framework.beans";
    public static final String DEFAULT_OSGI_FRAMEWORK_XML = "jboss-osgi-beans.xml";
    private EmbeddedBeansDeployer deployer = new EmbeddedBeansDeployer();
    private boolean bootstraped;
    private boolean configured;

    @Override
    public OSGiFramework getFramework() {
        return this.getFramework("jboss.osgi:service=Framework");
    }

    @Override
    public OSGiFramework getFramework(String beanName) {
        OSGiFramework framework = this.getInstance(beanName, OSGiFramework.class);
        if (framework == null && !this.configured) {
            this.configureWithDefaultBeans();
            framework = this.getInstance(beanName, OSGiFramework.class);
        }
        return framework;
    }

    @Override
    public void configure() {
        this.configureWithDefaultBeans();
    }

    @Override
    public void configure(InputStream streamConfig) {
        throw new NotImplementedException("Cannot bootstrap JBossMC from InputStream");
    }

    @Override
    public void configure(String resourceConfig) {
        URL urlConfig = Thread.currentThread().getContextClassLoader().getResource(resourceConfig);
        if (urlConfig == null) {
            throw new IllegalStateException("Cannot find resource: " + resourceConfig);
        }
        this.configure(urlConfig);
    }

    @Override
    public void configure(URL urlConfig) {
        this.deployer.deploy(urlConfig);
        this.configured = true;
    }

    @Override
    public Object getInstance(String name) {
        Object retObj = null;
        if (!this.bootstraped) {
            this.bootstrapKernel();
            this.bootstraped = true;
        }
        if ("jboss.kernel:service=Kernel".equals(name)) {
            retObj = this.deployer.getKernel();
        } else {
            KernelController controller = this.deployer.getKernel().getController();
            ControllerContext context = controller.getInstalledContext((Object)name);
            if (context != null) {
                retObj = context.getTarget();
            }
        }
        return retObj;
    }

    @Override
    public <T> T getInstance(String name, Class<T> expectedType) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expected type.");
        }
        Object attribute = this.getInstance(name);
        if (attribute != null) {
            if (!expectedType.isInstance(attribute)) {
                throw new IllegalArgumentException("Not of expected type [" + expectedType + "]: " + attribute);
            }
            return expectedType.cast(attribute);
        }
        return null;
    }

    private void configureWithDefaultBeans() {
        String defaultFrameworkBeans = System.getProperty(OSGI_FRAMEWORK_BEANS, DEFAULT_OSGI_FRAMEWORK_XML);
        this.configure(defaultFrameworkBeans);
    }

    private void bootstrapKernel() {
        String defaultBootstrapBeans = System.getProperty(OSGI_BOOTSTRAP_BEANS, DEFAULT_OSGI_BOOTSTRAP_XML);
        URL urlBootstrap = Thread.currentThread().getContextClassLoader().getResource(defaultBootstrapBeans);
        if (urlBootstrap != null) {
            this.deployer.deploy(urlBootstrap);
        }
    }
}

