/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.framework;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.framework.OSGiFramework;
import org.jboss.osgi.spi.service.DeploymentScannerService;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OSGiBootstrap {
    private static Logger log;
    private static final String JAVA_PROTOCOL_HANDLERS = "java.protocol.handler.pkgs";
    private static final String JBOSS_BIND_ADDRESS = "jboss.bind.address";
    private static final String OSGI_SERVER_NAME = "osgi.server.name";
    @Option(name="-c", aliases={"--server-name"}, usage="The runtime profile to start. (-c minimal)", required=false)
    public String serverName = "default";
    @Option(name="-b", aliases={"--bind-address"}, usage="The network address various services can bind to (-b 127.0.0.1)", required=false)
    public String bindAdress = "localhost";
    private String osgiHome;
    private String osgiServerHome;

    public static void main(String[] args) {
        OSGiBootstrap bean = new OSGiBootstrap();
        CmdLineParser parser = new CmdLineParser((Object)bean);
        try {
            parser.parseArgument(args);
            bean.run();
        }
        catch (CmdLineException ex) {
            System.err.println("Invalid OSGiBootstrap options");
            parser.printUsage((OutputStream)System.err);
        }
    }

    public void run() {
        this.initSystemProperties();
        OSGiBootstrapProvider bootProvider = OSGiBootstrap.getBootstrapProvider();
        OSGiFramework framework = bootProvider.getFramework();
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new ShutdownThread(framework));
        StartupThread thread = new StartupThread(framework);
        thread.start();
    }

    private void initSystemProperties() {
        this.osgiHome = System.getProperty("osgi.home");
        if (this.osgiHome == null) {
            throw new IllegalStateException("Cannot obtain system property: 'osgi.home'");
        }
        this.osgiServerHome = this.osgiHome + "/server/" + this.serverName;
        Properties defaults = new Properties();
        defaults.setProperty(OSGI_SERVER_NAME, this.serverName);
        defaults.setProperty("osgi.server.home", this.osgiServerHome);
        defaults.setProperty(JBOSS_BIND_ADDRESS, this.bindAdress);
        defaults.setProperty(JAVA_PROTOCOL_HANDLERS, "org.jboss.net.protocol|org.jboss.virtual.protocol");
        this.getLogger().debug((Object)"JBoss OSGi System Properties");
        this.getLogger().debug((Object)("   osgi.server.home=" + this.osgiServerHome));
        Enumeration<?> defaultNames = defaults.propertyNames();
        while (defaultNames.hasMoreElements()) {
            String propName = (String)defaultNames.nextElement();
            String sysValue = System.getProperty(propName);
            if (sysValue != null) continue;
            String propValue = defaults.getProperty(propName);
            System.setProperty(propName, propValue);
            this.getLogger().debug((Object)("   " + propName + "=" + propValue));
        }
    }

    private Logger getLogger() {
        if (log == null) {
            System.setProperty("osgi.server.home", this.osgiServerHome);
            log = Logger.getLogger(OSGiBootstrap.class);
        }
        return log;
    }

    public static OSGiBootstrapProvider getBootstrapProvider() {
        OSGiBootstrapProvider provider;
        ClassLoader ctxLoader;
        String providerName = System.getProperty(OSGiBootstrapProvider.class.getName());
        if (providerName == null) {
            ctxLoader = Thread.currentThread().getContextClassLoader();
            URL providerURL = ctxLoader.getResource(OSGiBootstrapProvider.class.getName());
            if (providerURL == null) {
                throw new IllegalStateException("Cannot find resource: " + OSGiBootstrapProvider.class.getName());
            }
            try {
                providerName = new BufferedReader(new InputStreamReader(providerURL.openStream())).readLine();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot read bootstrap provider name from: " + providerURL);
            }
        }
        if (providerName == null) {
            throw new IllegalStateException("Cannot obtain bootstrap provider");
        }
        try {
            ctxLoader = Thread.currentThread().getContextClassLoader();
            Class<?> providerClass = ctxLoader.loadClass(providerName);
            provider = (OSGiBootstrapProvider)providerClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load bootstrap provider: " + providerName);
        }
        return provider;
    }

    class ShutdownThread
    extends Thread {
        private OSGiFramework framework;

        public ShutdownThread(OSGiFramework framework) {
            this.framework = framework;
        }

        public void run() {
            OSGiBootstrap.this.getLogger().info((Object)"Initiating shutdown ...");
            this.framework.stop();
            OSGiBootstrap.this.getLogger().info((Object)"Shutdown complete");
        }
    }

    class StartupThread
    extends Thread {
        private OSGiFramework framework;

        public StartupThread(OSGiFramework framework) {
            this.framework = framework;
        }

        public void run() {
            final long beforeStart = System.currentTimeMillis();
            this.framework.start();
            final long afterStart = System.currentTimeMillis();
            BundleContext context = this.framework.getBundleContext();
            ServiceReference sref = context.getServiceReference(DeploymentScannerService.class.getName());
            if (sref != null) {
                DeploymentScannerService scannerService = (DeploymentScannerService)context.getService(sref);
                DeploymentScannerService.ScanListener listener = new DeploymentScannerService.ScanListener(){

                    public void beforeScan(DeploymentScannerService service) {
                    }

                    public void afterScan(DeploymentScannerService service) {
                        long lastChange = service.getLastChange();
                        if (lastChange > afterStart) {
                            float diff = (float)(lastChange - beforeStart) / 1000.0f;
                            OSGiBootstrap.this.getLogger().info((Object)("JBossOSGi Runtime started in " + diff + "sec"));
                        }
                        service.removeScanListener(this);
                    }
                };
                scannerService.addScanListener(listener);
            }
            float diff = (float)(afterStart - beforeStart) / 1000.0f;
            OSGiBootstrap.this.getLogger().info((Object)("JBossOSGi Runtime booted in " + diff + "sec"));
            InputStreamReader br = new InputStreamReader(System.in);
            try {
                int inByte = ((Reader)br).read();
                while (inByte != 0) {
                    inByte = ((Reader)br).read();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }
}

