/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.logging;

import java.util.ArrayList;
import java.util.Collections;
import org.jboss.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public final class ExportedPackageHelper {
    final Logger log = Logger.getLogger(ExportedPackageHelper.class);
    private PackageAdmin packageAdmin;

    public ExportedPackageHelper(BundleContext context) {
        ServiceReference sref = context.getServiceReference(PackageAdmin.class.getName());
        this.packageAdmin = (PackageAdmin)context.getService(sref);
    }

    public boolean resolveBundle(Bundle bundle) {
        return this.packageAdmin.resolveBundles(new Bundle[]{bundle});
    }

    public boolean resolveBundles(Bundle[] bundles) {
        return this.packageAdmin.resolveBundles(bundles);
    }

    public void logExportedPackages(Bundle bundle) {
        this.log.debug((Object)("Exported-Packages: " + bundle.getSymbolicName()));
        ExportedPackage[] exportedPackages = this.packageAdmin.getExportedPackages(bundle);
        if (exportedPackages != null) {
            ArrayList<String> packages = new ArrayList<String>();
            for (ExportedPackage exp : exportedPackages) {
                packages.add("  " + exp.getName() + ";version=" + exp.getVersion());
            }
            Collections.sort(packages);
            for (String exp : packages) {
                this.log.debug((Object)exp);
            }
        }
    }
}

