/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.logging.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;

public class LogEntryImpl
implements LogEntry {
    private long time;
    private int level;
    private Bundle bundle;
    private ServiceReference sref;
    private String message;
    private Throwable exception;
    private String bndStr;
    private String srefStr;

    public LogEntryImpl(LogEntry le) {
        this(le.getTime(), le.getBundle(), le.getServiceReference(), le.getLevel(), le.getMessage(), le.getException());
    }

    public LogEntryImpl(long time, Bundle bundle, ServiceReference sref, int level, String message, Throwable exception) {
        this.time = time;
        this.bundle = bundle;
        this.sref = sref;
        this.level = level;
        this.message = message;
        this.exception = exception;
        if (bundle != null) {
            this.bndStr = bundle.getSymbolicName();
        }
        if (sref != null && sref.getBundle() != null) {
            this.srefStr = sref.getBundle().getSymbolicName();
        }
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Throwable getException() {
        return this.exception;
    }

    public int getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public ServiceReference getServiceReference() {
        return this.sref;
    }

    public long getTime() {
        return this.time;
    }

    private String logLevel(int level) {
        String logLevel;
        switch (level) {
            case 4: {
                logLevel = "DEBUG";
                break;
            }
            case 3: {
                logLevel = "INFO";
                break;
            }
            case 2: {
                logLevel = "WARN";
                break;
            }
            case 1: {
                logLevel = "ERROR";
                break;
            }
            default: {
                logLevel = "Level=" + level;
            }
        }
        return logLevel;
    }

    public String toString() {
        String t = new SimpleDateFormat("dd-MMM-yyyy HH:mm.ss.SSS").format(new Date(this.time));
        String l = " " + this.logLevel(this.level);
        String s = this.srefStr != null ? ",sref=" + this.srefStr : "";
        String b = ",bnd=" + this.bndStr;
        String m = ",msg=" + this.message;
        String e = this.exception != null ? ",ex=" + this.exception : "";
        return "[" + t + l + b + s + m + e + "]";
    }
}

