/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.management;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.ObjectName;
import org.jboss.osgi.spi.management.ManagedBundleMBean;
import org.jboss.osgi.spi.management.ObjectNameFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedBundle
implements ManagedBundleMBean {
    private Bundle bundle;
    private ObjectName oname;

    public ManagedBundle(Bundle bundle) {
        this.bundle = bundle;
        this.oname = ObjectNameFactory.create("jboss.osgi:bundle=" + bundle.getSymbolicName() + ",id=" + bundle.getBundleId());
    }

    @Override
    public ObjectName getObjectName() {
        return this.oname;
    }

    @Override
    public String getProperty(String key) {
        return this.bundle.getBundleContext().getProperty(key);
    }

    @Override
    public int getState() {
        return this.bundle.getState();
    }

    @Override
    public long getBundleId() {
        return this.bundle.getBundleId();
    }

    @Override
    public String getSymbolicName() {
        return this.bundle.getSymbolicName();
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        Hashtable<String, String> retHeaders = new Hashtable<String, String>();
        Dictionary bundleHeaders = this.bundle.getHeaders();
        Enumeration keys = bundleHeaders.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)bundleHeaders.get(key);
            retHeaders.put(key, value);
        }
        return retHeaders;
    }

    @Override
    public void start() throws BundleException {
        this.bundle.start();
    }

    @Override
    public void stop() throws BundleException {
        this.bundle.stop();
    }
}

