/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.testing.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.capability.Capability;
import org.jboss.osgi.spi.logging.LogEntryCache;
import org.jboss.osgi.spi.testing.OSGiBundle;
import org.jboss.osgi.spi.testing.OSGiRuntime;
import org.jboss.osgi.spi.testing.OSGiServiceReference;
import org.jboss.osgi.spi.testing.OSGiTestHelper;
import org.osgi.framework.BundleException;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

public abstract class OSGiRuntimeImpl
implements OSGiRuntime {
    final Logger log = Logger.getLogger(OSGiRuntimeImpl.class);
    private OSGiTestHelper helper;
    private Map<String, OSGiBundle> capBundles = new HashMap<String, OSGiBundle>();
    private List<Capability> capabilities = new ArrayList<Capability>();
    private LogReaderService logReaderService;
    private LogEntryCache logEntryCache;

    public OSGiRuntimeImpl(OSGiTestHelper helper) {
        this.helper = helper;
    }

    public OSGiTestHelper getTestHelper() {
        return this.helper;
    }

    protected void setLogReaderService(LogReaderService logReaderService) {
        this.logReaderService = logReaderService;
    }

    protected LogReaderService getLogReaderService() {
        return this.logReaderService;
    }

    public void addCapability(Capability capability) throws BundleException {
        for (Capability dependency : capability.getDependencies()) {
            this.addCapability(dependency);
        }
        OSGiServiceReference sref = this.getServiceReference(capability.getServiceName());
        if (sref == null) {
            this.log.debug((Object)("Add capability: " + capability));
            for (String location : capability.getBundles()) {
                String symName = this.getSymbolicName(location);
                if (this.capBundles.get(location) == null && this.getBundle(symName, null) == null) {
                    OSGiBundle bundle = this.installBundle(location);
                    bundle.start();
                    this.capBundles.put(location, bundle);
                    continue;
                }
                this.log.debug((Object)("Skip bundle: " + location));
            }
            this.capabilities.add(capability);
        } else {
            this.log.debug((Object)("Skip capability : " + capability));
        }
    }

    public void removeCapability(Capability capability) {
        if (this.capabilities.remove(capability)) {
            this.log.debug((Object)("Remove capability : " + capability));
            List<String> bundleLocations = capability.getBundles();
            Collections.reverse(bundleLocations);
            for (String location : bundleLocations) {
                OSGiBundle bundle = this.capBundles.remove(location);
                if (bundle == null) continue;
                try {
                    bundle.uninstall();
                }
                catch (BundleException ex) {
                    this.log.error((Object)("Cannot uninstall bundle: " + bundle));
                }
            }
        }
        List<Capability> dependencies = capability.getDependencies();
        Collections.reverse(dependencies);
        for (Capability dependency : dependencies) {
            this.removeCapability(dependency);
        }
    }

    public void startLogEntryTracking(LogEntryCache logEntryCache) {
        this.logEntryCache = logEntryCache;
    }

    public void stopLogEntryTracking() {
        if (this.logReaderService != null && this.logEntryCache != null) {
            this.logReaderService.removeLogListener((LogListener)this.logEntryCache);
            this.logReaderService = null;
            this.logEntryCache = null;
        }
    }

    public void shutdown() {
        this.log.debug((Object)"Start Shutdown");
        this.stopLogEntryTracking();
        while (this.capabilities.size() > 0) {
            Capability capability = this.capabilities.get(0);
            this.removeCapability(capability);
        }
        this.log.debug((Object)"End Shutdown");
    }

    protected void deploy(String location) throws Exception {
        URL archiveURL = this.getTestHelper().getTestArchiveURL(location);
        this.invokeDeployerService("deploy", archiveURL);
    }

    protected void undeploy(String location) throws Exception {
        URL archiveURL = this.getTestHelper().getTestArchiveURL(location);
        this.invokeDeployerService("undeploy", archiveURL);
    }

    private void invokeDeployerService(String method, URL archiveURL) throws Exception {
        ObjectName oname = new ObjectName("jboss.osgi:service=DeployerService");
        this.getMBeanServer().invoke(oname, method, new Object[]{archiveURL}, new String[]{"java.net.URL"});
    }

    public InitialContext getInitialContext() throws NamingException {
        return this.helper.getInitialContext();
    }

    public String getServerHost() {
        return this.helper.getServerHost();
    }

    public OSGiBundle getBundle(String symbolicName, String version) {
        OSGiBundle bundle = null;
        for (OSGiBundle aux : this.getBundles()) {
            if (!aux.getSymbolicName().equals(symbolicName) || version != null && !version.equals(aux.getVersion())) continue;
            bundle = aux;
            break;
        }
        return bundle;
    }

    protected String getSymbolicName(String location) {
        Manifest manifest;
        try {
            File archiveFile = this.getTestHelper().getTestArchiveFile(location);
            JarFile jarFile = new JarFile(archiveFile);
            manifest = jarFile.getManifest();
            jarFile.close();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot get manifest from: " + location);
        }
        Attributes attribs = manifest.getMainAttributes();
        String symbolicName = attribs.getValue("Bundle-SymbolicName");
        if (symbolicName == null) {
            throw new IllegalArgumentException("Cannot obtain Bundle-SymbolicName for: " + location);
        }
        return symbolicName;
    }
}

