/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.testing.internal;

import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.osgi.spi.capability.RemoteLogCapability;
import org.jboss.osgi.spi.logging.LogEntryCache;
import org.jboss.osgi.spi.logging.RemoteLogReaderService;
import org.jboss.osgi.spi.management.MBeanProxy;
import org.jboss.osgi.spi.management.MBeanProxyException;
import org.jboss.osgi.spi.management.ManagedBundleMBean;
import org.jboss.osgi.spi.management.ManagedFrameworkMBean;
import org.jboss.osgi.spi.management.ManagedServiceReference;
import org.jboss.osgi.spi.testing.OSGiBundle;
import org.jboss.osgi.spi.testing.OSGiPackageAdmin;
import org.jboss.osgi.spi.testing.OSGiServiceReference;
import org.jboss.osgi.spi.testing.OSGiTestHelper;
import org.jboss.osgi.spi.testing.internal.EmbeddedRuntime;
import org.jboss.osgi.spi.testing.internal.OSGiRuntimeImpl;
import org.jboss.osgi.spi.testing.internal.RemoteBundle;
import org.jboss.osgi.spi.testing.internal.RemoteFramework;
import org.jboss.osgi.spi.testing.internal.RemoteFrameworkException;
import org.jboss.osgi.spi.testing.internal.RemotePackageAdmin;
import org.jboss.osgi.spi.testing.internal.RemoteServiceReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.util.tracker.ServiceTracker;

public class RemoteRuntime
extends OSGiRuntimeImpl {
    private MBeanServerConnection mbeanServer;
    private ManagedFrameworkMBean managedFramework;
    private EmbeddedRuntime embeddedRuntime;
    private RemoteLogCapability remoteLogCapability;

    public RemoteRuntime(OSGiTestHelper helper) {
        super(helper);
    }

    public OSGiBundle installBundle(String location) throws BundleException {
        String symbolicName = this.getSymbolicName(location);
        try {
            this.deploy(location);
            ManagedBundleMBean bundle = this.getRemoteFramework().getBundle(symbolicName);
            return new RemoteBundle(this, bundle, location);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new BundleException("Cannot install: " + location, (Throwable)ex);
        }
    }

    public void deploy(String location) throws Exception {
        super.deploy(location);
    }

    public void undeploy(String location) throws Exception {
        super.undeploy(location);
    }

    public OSGiBundle[] getBundles() {
        try {
            Set<ManagedBundleMBean> remoteBundles = this.getRemoteFramework().getBundles();
            HashSet<RemoteBundle> bundles = new HashSet<RemoteBundle>();
            for (ManagedBundleMBean remoteBundle : remoteBundles) {
                bundles.add(new RemoteBundle(this, remoteBundle, null));
            }
            OSGiBundle[] bundleArr = new OSGiBundle[bundles.size()];
            bundles.toArray(bundleArr);
            return bundleArr;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot obtain remote bundles", ex);
        }
    }

    public OSGiServiceReference getServiceReference(String clazz) {
        ManagedServiceReference manref = this.getRemoteFramework().getServiceReference(clazz);
        return manref != null ? new RemoteServiceReference(manref) : null;
    }

    public OSGiServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        OSGiServiceReference[] srefs = null;
        ManagedServiceReference[] manrefs = this.getRemoteFramework().getServiceReferences(clazz, filter);
        if (manrefs != null) {
            srefs = new OSGiServiceReference[manrefs.length];
            for (int i = 0; i < manrefs.length; ++i) {
                srefs[i] = new RemoteServiceReference(manrefs[i]);
            }
        }
        return srefs;
    }

    public void startLogEntryTracking(final LogEntryCache logEntryCache) {
        super.startLogEntryTracking(logEntryCache);
        try {
            this.remoteLogCapability = new RemoteLogCapability();
            this.addCapability(this.remoteLogCapability);
            this.embeddedRuntime = (EmbeddedRuntime)this.getTestHelper().getEmbeddedRuntime();
            this.embeddedRuntime.addCapability(this.remoteLogCapability);
            BundleContext context = this.embeddedRuntime.getBundleContext();
            ServiceTracker tracker = new ServiceTracker(context, RemoteLogReaderService.class.getName(), null){

                public Object addingService(ServiceReference sref) {
                    LogReaderService logReaderService = (LogReaderService)super.addingService(sref);
                    logReaderService.addLogListener((LogListener)logEntryCache);
                    RemoteRuntime.this.setLogReaderService(logReaderService);
                    return logReaderService;
                }
            };
            tracker.open();
        }
        catch (BundleException ex) {
            throw new IllegalStateException("Cannot start log entry tracking", ex);
        }
    }

    public void stopLogEntryTracking() {
        if (this.remoteLogCapability != null) {
            this.removeCapability(this.remoteLogCapability);
            this.remoteLogCapability = null;
        }
        if (this.embeddedRuntime != null) {
            this.embeddedRuntime.shutdown();
            this.embeddedRuntime = null;
        }
        super.stopLogEntryTracking();
    }

    public MBeanServerConnection getMBeanServer() {
        if (this.mbeanServer == null) {
            try {
                InitialContext iniCtx = this.getInitialContext();
                this.mbeanServer = (MBeanServerConnection)iniCtx.lookup("jmx/invoker/RMIAdaptor");
            }
            catch (NamingException ex) {
                throw new IllegalStateException("Cannot obtain MBeanServerConnection", ex);
            }
        }
        return this.mbeanServer;
    }

    public OSGiPackageAdmin getPackageAdmin() {
        return new RemotePackageAdmin(this);
    }

    public void shutdown() {
        super.shutdown();
        this.getPackageAdmin().refreshPackages(null);
    }

    private RemoteFramework getRemoteFramework() {
        try {
            if (this.managedFramework == null) {
                this.managedFramework = MBeanProxy.get(ManagedFrameworkMBean.class, ManagedFrameworkMBean.MBEAN_MANAGED_FRAMEWORK, this.getMBeanServer());
            }
        }
        catch (MBeanProxyException ex) {
            throw new RemoteFrameworkException(ex);
        }
        return new RemoteFramework(){

            @Override
            public ManagedBundleMBean getBundle(String symbolicName) {
                ObjectName oname = RemoteRuntime.this.managedFramework.getBundle(symbolicName);
                if (oname == null) {
                    throw new IllegalArgumentException("Cannot get remote bundle for: " + symbolicName);
                }
                try {
                    return MBeanProxy.get(ManagedBundleMBean.class, oname, RemoteRuntime.this.getMBeanServer());
                }
                catch (MBeanProxyException ex) {
                    throw new RemoteFrameworkException(ex);
                }
            }

            @Override
            public Set<ManagedBundleMBean> getBundles() {
                HashSet<ManagedBundleMBean> remBundles = new HashSet<ManagedBundleMBean>();
                for (ObjectName bundleOName : RemoteRuntime.this.managedFramework.getBundles()) {
                    try {
                        ManagedBundleMBean remBundle = MBeanProxy.get(ManagedBundleMBean.class, bundleOName, RemoteRuntime.this.getMBeanServer());
                        remBundles.add(remBundle);
                    }
                    catch (MBeanProxyException ex) {
                        throw new RemoteFrameworkException(ex);
                    }
                }
                return remBundles;
            }

            @Override
            public ManagedServiceReference getServiceReference(String clazz) {
                return RemoteRuntime.this.managedFramework.getServiceReference(clazz);
            }

            @Override
            public ManagedServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
                return RemoteRuntime.this.managedFramework.getServiceReferences(clazz, filter);
            }
        };
    }
}

