/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.FrameworkException;
import org.jboss.osgi.spi.NotImplementedException;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.internal.StringPropertyReplacer;
import org.jboss.osgi.spi.logging.ExportedPackageHelper;
import org.jboss.osgi.spi.util.ServiceLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesBootstrapProvider
implements OSGiBootstrapProvider {
    final Logger log = Logger.getLogger(PropertiesBootstrapProvider.class);
    public static final String OSGI_FRAMEWORK_CONFIG = "jboss.osgi.framework.properties";
    public static final String DEFAULT_OSGI_FRAMEWORK_PROPERTIES = "jboss-osgi-framework.properties";
    public static final String PROP_OSGI_FRAMEWORK_AUTO_INSTALL = "org.jboss.osgi.spi.framework.autoInstall";
    public static final String PROP_OSGI_FRAMEWORK_AUTO_START = "org.jboss.osgi.spi.framework.autoStart";
    public static final String PROP_OSGI_FRAMEWORK_EXTRA = "org.jboss.osgi.spi.framework.extra";
    private static Set<String> internalProps = new HashSet<String>();
    private Framework framework;
    private boolean configured;

    @Override
    public void configure() {
        this.configure(System.getProperty(OSGI_FRAMEWORK_CONFIG, DEFAULT_OSGI_FRAMEWORK_PROPERTIES));
    }

    @Override
    public void configure(URL urlConfig) {
        final Map<String, Object> props = this.getBootstrapProperties(urlConfig);
        FrameworkFactory factory = ServiceLoader.loadService(FrameworkFactory.class);
        final Framework frameworkImpl = factory.newFramework(props);
        this.framework = new FrameworkDelegate(frameworkImpl){

            public void start() throws BundleException {
                Bundle bundle;
                super.start();
                BundleContext context = PropertiesBootstrapProvider.this.framework.getBundleContext();
                if (context == null) {
                    throw new FrameworkException("Cannot obtain system context");
                }
                ExportedPackageHelper packageHelper = new ExportedPackageHelper(context);
                packageHelper.logExportedPackages((Bundle)frameworkImpl);
                List autoInstall = PropertiesBootstrapProvider.this.getBundleURLs(props, PropertiesBootstrapProvider.PROP_OSGI_FRAMEWORK_AUTO_INSTALL);
                List autoStart = PropertiesBootstrapProvider.this.getBundleURLs(props, PropertiesBootstrapProvider.PROP_OSGI_FRAMEWORK_AUTO_START);
                HashMap<URL, Bundle> autoBundles = new HashMap<URL, Bundle>();
                for (URL bundleURL : autoStart) {
                    autoInstall.add(bundleURL);
                }
                for (URL bundleURL : autoInstall) {
                    bundle = context.installBundle(bundleURL.toString());
                    long bundleId = bundle.getBundleId();
                    PropertiesBootstrapProvider.this.log.info((Object)("Installed bundle [" + bundleId + "]: " + bundle.getSymbolicName()));
                    autoBundles.put(bundleURL, bundle);
                }
                for (URL bundleURL : autoStart) {
                    bundle = (Bundle)autoBundles.get(bundleURL);
                    if (bundle == null) continue;
                    bundle.start();
                    packageHelper.logExportedPackages(bundle);
                    PropertiesBootstrapProvider.this.log.info((Object)("Started bundle: " + bundle.getSymbolicName()));
                }
            }
        };
        this.configured = true;
    }

    private List<URL> getBundleURLs(Map<String, Object> props, String key) {
        String bundleList = (String)props.get(key);
        if (bundleList == null) {
            bundleList = "";
        }
        ArrayList<URL> bundleURLs = new ArrayList<URL>();
        for (String bundle : bundleList.split("[, ]")) {
            if (bundle.trim().length() <= 0) continue;
            URL installURL = this.toURL(bundle);
            bundleURLs.add(installURL);
        }
        return bundleURLs;
    }

    private URL toURL(String path) {
        String realPath = StringPropertyReplacer.replaceProperties(path);
        try {
            URL pathURL = new URL(realPath);
            return pathURL;
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("Invalid path: " + path, ex);
        }
    }

    @Override
    public void configure(String resourceConfig) {
        URL urlConfig = Thread.currentThread().getContextClassLoader().getResource(resourceConfig);
        if (urlConfig == null) {
            throw new IllegalStateException("Cannot find resource: " + resourceConfig);
        }
        this.configure(urlConfig);
    }

    @Override
    public void configure(InputStream streamConfig) {
        throw new NotImplementedException();
    }

    @Override
    public Framework getFramework() {
        if (!this.configured) {
            String defaultFrameworkProps = System.getProperty(OSGI_FRAMEWORK_CONFIG, DEFAULT_OSGI_FRAMEWORK_PROPERTIES);
            this.configure(defaultFrameworkProps);
        }
        return this.framework;
    }

    private Map<String, Object> getBootstrapProperties(URL urlConfig) {
        Properties props = new Properties();
        try {
            InputStream inStream = urlConfig.openStream();
            props.load(inStream);
            inStream.close();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot load properties from: " + urlConfig, ex);
        }
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = props.getProperty(key);
            value = StringPropertyReplacer.replaceProperties(value);
            propMap.put(key, value);
            if (!key.endsWith(".instance")) continue;
            try {
                String subkey = key.substring(0, key.lastIndexOf(".instance"));
                Object instance = Class.forName(value).newInstance();
                propMap.put(subkey, instance);
            }
            catch (Exception ex) {
                this.log.error((Object)("Cannot load " + key + "=" + value), (Throwable)ex);
            }
        }
        String extraPropsValue = (String)propMap.get(PROP_OSGI_FRAMEWORK_EXTRA);
        if (extraPropsValue != null) {
            URL extraPropsURL = null;
            try {
                extraPropsURL = new URL(extraPropsValue);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (extraPropsURL == null) {
                File propsFile = new File(extraPropsValue);
                try {
                    extraPropsURL = propsFile.toURL();
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (extraPropsURL == null) {
                throw new IllegalStateException("Invalid properties URL: " + extraPropsValue);
            }
            propMap.remove(PROP_OSGI_FRAMEWORK_EXTRA);
            Map<String, Object> extraProps = this.getBootstrapProperties(extraPropsURL);
            propMap.putAll(extraProps);
        }
        return propMap;
    }

    static {
        internalProps.add(PROP_OSGI_FRAMEWORK_AUTO_INSTALL);
        internalProps.add(PROP_OSGI_FRAMEWORK_AUTO_START);
        internalProps.add(PROP_OSGI_FRAMEWORK_EXTRA);
    }

    class FrameworkDelegate
    implements Framework {
        private Framework framework;

        FrameworkDelegate(Framework framework) {
            this.framework = framework;
        }

        public Enumeration findEntries(String path, String filePattern, boolean recurse) {
            return this.framework.findEntries(path, filePattern, recurse);
        }

        public BundleContext getBundleContext() {
            return this.framework.getBundleContext();
        }

        public long getBundleId() {
            return this.framework.getBundleId();
        }

        public URL getEntry(String path) {
            return this.framework.getEntry(path);
        }

        public Enumeration getEntryPaths(String path) {
            return this.framework.getEntryPaths(path);
        }

        public Dictionary getHeaders() {
            return this.framework.getHeaders();
        }

        public Dictionary getHeaders(String locale) {
            return this.framework.getHeaders(locale);
        }

        public long getLastModified() {
            return this.framework.getLastModified();
        }

        public String getLocation() {
            return this.framework.getLocation();
        }

        public ServiceReference[] getRegisteredServices() {
            return this.framework.getRegisteredServices();
        }

        public URL getResource(String name) {
            return this.framework.getResource(name);
        }

        public Enumeration getResources(String name) throws IOException {
            return this.framework.getResources(name);
        }

        public ServiceReference[] getServicesInUse() {
            return this.framework.getServicesInUse();
        }

        public Map getSignerCertificates(int signersType) {
            return this.framework.getSignerCertificates(signersType);
        }

        public int getState() {
            return this.framework.getState();
        }

        public String getSymbolicName() {
            return this.framework.getSymbolicName();
        }

        public Version getVersion() {
            return this.framework.getVersion();
        }

        public boolean hasPermission(Object permission) {
            return this.framework.hasPermission(permission);
        }

        public void init() throws BundleException {
            this.framework.init();
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return this.framework.loadClass(name);
        }

        public void start() throws BundleException {
            this.framework.start();
        }

        public void start(int options) throws BundleException {
            this.framework.start(options);
        }

        public void stop() throws BundleException {
            this.framework.stop();
        }

        public void stop(int options) throws BundleException {
            this.framework.stop(options);
        }

        public void uninstall() throws BundleException {
            this.framework.uninstall();
        }

        public void update() throws BundleException {
            this.framework.update();
        }

        public void update(InputStream in) throws BundleException {
            this.framework.update(in);
        }

        public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
            return this.framework.waitForStop(timeout);
        }
    }
}

