/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.testing;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.osgi.spi.framework.OSGiBootstrap;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.testing.OSGiRuntime;
import org.jboss.osgi.spi.testing.internal.EmbeddedRuntime;
import org.jboss.osgi.spi.testing.internal.RemoteRuntime;

public class OSGiTestHelper {
    private static final String SYSPROP_TEST_RESOURCES_DIRECTORY = "test.resources.directory";
    private static final String SYSPROP_TEST_ARCHIVE_DIRECTORY = "test.archive.directory";
    private OSGiBootstrapProvider bootProvider;
    private boolean skipCreateBootstrapProvider;
    private static String testResourcesDir;
    private static String testArchiveDir;

    public OSGiTestHelper() {
        testResourcesDir = System.getProperty(SYSPROP_TEST_RESOURCES_DIRECTORY, "target/test-classes");
        testArchiveDir = System.getProperty(SYSPROP_TEST_ARCHIVE_DIRECTORY, "target/test-libs");
    }

    public OSGiBootstrapProvider getBootstrapProvider() {
        if (this.bootProvider == null && !this.skipCreateBootstrapProvider) {
            try {
                this.bootProvider = OSGiBootstrap.getBootstrapProvider();
            }
            catch (RuntimeException rte) {
                this.skipCreateBootstrapProvider = true;
                throw rte;
            }
        }
        return this.bootProvider;
    }

    public OSGiRuntime getDefaultRuntime() {
        String target = System.getProperty("target.container");
        OSGiRuntime runtime = target == null ? this.getEmbeddedRuntime() : this.getRemoteRuntime();
        return runtime;
    }

    public OSGiRuntime getEmbeddedRuntime() {
        return new EmbeddedRuntime(this);
    }

    public OSGiRuntime getRemoteRuntime() {
        return new RemoteRuntime(this);
    }

    public URL getResourceURL(String resource) {
        URL resURL = null;
        try {
            File resourceFile = this.getResourceFile(resource);
            resURL = resourceFile.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return resURL;
    }

    public File getResourceFile(String resource) {
        File file = new File(resource);
        if (file.exists()) {
            return file;
        }
        file = new File(testResourcesDir + "/" + resource);
        if (file.exists()) {
            return file;
        }
        throw new IllegalArgumentException("Cannot obtain '" + testResourcesDir + "/" + resource + "'");
    }

    public URL getTestArchiveURL(String archive) {
        try {
            return this.getTestArchiveFile(archive).toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String getTestArchivePath(String archive) {
        return this.getTestArchiveFile(archive).getAbsolutePath();
    }

    public File getTestArchiveFile(String archive) {
        File file = new File(archive);
        if (file.exists()) {
            return file;
        }
        file = new File(testArchiveDir + "/" + archive);
        if (file.exists()) {
            return file;
        }
        throw new IllegalArgumentException("Cannot obtain '" + testArchiveDir + "/" + archive + "'.");
    }

    public InitialContext getInitialContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        env.put("java.naming.provider.url", "jnp://" + this.getServerHost() + ":" + this.getJndiPort());
        return new InitialContext(env);
    }

    public Integer getJndiPort() {
        String port = System.getProperty("jndi.server.port", "1099");
        return new Integer(port);
    }

    public String getServerHost() {
        return System.getProperty("jboss.bind.address", "localhost");
    }

    public String getTargetContainer() {
        return System.getProperty("target.container");
    }

    public String getFramework() {
        return System.getProperty("framework", "jbossmc");
    }

    public boolean isFrameworkEquinox() {
        return "equinox".equals(this.getFramework());
    }

    public boolean isFrameworkFelix() {
        return "felix".equals(this.getFramework());
    }

    public boolean isFrameworkJBossMC() {
        return "jbossmc".equals(this.getFramework());
    }
}

