/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.testing.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.capability.Capability;
import org.jboss.osgi.spi.testing.OSGiBundle;
import org.jboss.osgi.spi.testing.OSGiRuntime;
import org.jboss.osgi.spi.testing.OSGiServiceReference;
import org.jboss.osgi.spi.testing.OSGiTestHelper;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public abstract class OSGiRuntimeImpl
implements OSGiRuntime {
    final Logger log = Logger.getLogger(OSGiRuntimeImpl.class);
    private OSGiTestHelper helper;
    private Map<String, OSGiBundle> bundles = new LinkedHashMap<String, OSGiBundle>();
    private List<Capability> capabilities = new ArrayList<Capability>();

    public OSGiRuntimeImpl(OSGiTestHelper helper) {
        this.helper = helper;
    }

    public OSGiTestHelper getTestHelper() {
        return this.helper;
    }

    public void addCapability(Capability capability) throws BundleException, InvalidSyntaxException {
        for (Capability dependency : capability.getDependencies()) {
            this.addCapability(dependency);
        }
        OSGiServiceReference[] srefs = null;
        String serviceName = capability.getServiceName();
        if (serviceName != null) {
            srefs = this.getServiceReferences(serviceName, capability.getFilter());
        }
        if (srefs == null || srefs.length == 0) {
            this.log.debug((Object)("Add capability: " + capability));
            for (String location : capability.getBundles()) {
                String symName = this.getManifestEntry(location, "Bundle-SymbolicName");
                if (this.bundles.get(location) == null && this.getBundle(symName, null) == null) {
                    OSGiBundle bundle = this.installBundle(location);
                    bundle.start();
                    continue;
                }
                this.log.debug((Object)("Skip bundle: " + location));
            }
            this.capabilities.add(capability);
        } else {
            this.log.debug((Object)("Skip capability : " + capability));
        }
    }

    public void removeCapability(Capability capability) {
        if (this.capabilities.remove(capability)) {
            this.log.debug((Object)("Remove capability : " + capability));
            ArrayList<String> bundleLocations = new ArrayList<String>(capability.getBundles());
            Collections.reverse(bundleLocations);
            for (String location : bundleLocations) {
                this.failsafeUninstall(this.bundles.remove(location));
            }
        }
        ArrayList<Capability> dependencies = new ArrayList<Capability>(capability.getDependencies());
        Collections.reverse(dependencies);
        for (Capability dependency : dependencies) {
            this.removeCapability(dependency);
        }
    }

    public void shutdown() {
        this.log.debug((Object)"Start Shutdown");
        ArrayList<String> locations = new ArrayList<String>(this.bundles.keySet());
        Collections.reverse(locations);
        while (locations.size() > 0) {
            String location = locations.remove(0);
            this.failsafeUninstall(this.bundles.remove(location));
        }
        Collections.reverse(this.capabilities);
        while (this.capabilities.size() > 0) {
            Capability capability = this.capabilities.get(0);
            this.removeCapability(capability);
        }
        this.log.debug((Object)"End Shutdown");
    }

    protected void deploy(String location) throws Exception {
        URL archiveURL = this.getTestHelper().getTestArchiveURL(location);
        this.invokeDeployerService("deploy", archiveURL);
    }

    protected void undeploy(String location) throws Exception {
        URL archiveURL = this.getTestHelper().getTestArchiveURL(location);
        this.invokeDeployerService("undeploy", archiveURL);
    }

    protected void invokeDeployerService(String method, URL archiveURL) throws Exception {
        ObjectName oname = new ObjectName("jboss.osgi:service=DeployerService");
        this.getMBeanServer().invoke(oname, method, new Object[]{archiveURL}, new String[]{URL.class.getName()});
    }

    public InitialContext getInitialContext() throws NamingException {
        return this.helper.getInitialContext();
    }

    public String getServerHost() {
        return this.helper.getServerHost();
    }

    public OSGiBundle getBundle(String symbolicName, Version version) {
        OSGiBundle bundle = this.getBundle(symbolicName, version, false);
        return bundle;
    }

    protected OSGiBundle getBundle(String symbolicName, Version version, boolean mustExist) {
        OSGiBundle bundle = null;
        List<OSGiBundle> bundles = Arrays.asList(this.getBundles());
        for (OSGiBundle aux : bundles) {
            if (!aux.getSymbolicName().equals(symbolicName) || version != null && !version.equals((Object)aux.getVersion())) continue;
            bundle = aux;
            break;
        }
        if (bundle == null && mustExist) {
            throw new IllegalStateException("Cannot obtain bundle: " + symbolicName + "-" + version + ". We have " + bundles);
        }
        return bundle;
    }

    protected String getManifestEntry(String location, String key) {
        Manifest manifest = this.getManifest(location);
        Attributes attribs = manifest.getMainAttributes();
        String value = attribs.getValue(key);
        return value;
    }

    private Manifest getManifest(String location) {
        Manifest manifest;
        try {
            File archiveFile = this.getTestHelper().getTestArchiveFile(location);
            JarFile jarFile = new JarFile(archiveFile);
            manifest = jarFile.getManifest();
            jarFile.close();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot get manifest from: " + location);
        }
        return manifest;
    }

    OSGiBundle registerBundle(String location, OSGiBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Cannot register null bundle for: " + location);
        }
        this.bundles.put(location, bundle);
        return bundle;
    }

    void unregisterBundle(OSGiBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Cannot unregister null bundle");
        }
        if (this.bundles.containsValue(bundle)) {
            Set<Map.Entry<String, OSGiBundle>> entrySet = this.bundles.entrySet();
            for (Map.Entry<String, OSGiBundle> entry : entrySet) {
                if (!bundle.equals(entry.getValue())) continue;
                String key = entry.getKey();
                this.bundles.remove(key);
                break;
            }
        }
    }

    private void failsafeUninstall(OSGiBundle bundle) {
        if (bundle != null) {
            try {
                if (bundle.getState() != 1) {
                    bundle.uninstall();
                }
            }
            catch (Exception ex) {
                this.log.warn((Object)("Cannot uninstall bundle: " + bundle), (Throwable)ex);
            }
        }
    }
}

