/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.testing.internal;

import java.util.Dictionary;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.management.ManagedBundleMBean;
import org.jboss.osgi.spi.testing.OSGiBundle;
import org.jboss.osgi.spi.testing.internal.OSGiRuntimeImpl;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteBundle
extends OSGiBundle {
    private static final Logger log = Logger.getLogger(RemoteBundle.class);
    private OSGiRuntimeImpl runtime;
    private ManagedBundleMBean bundle;
    private boolean uninstalled;
    private String location;
    private long bundleId;
    private String symbolicName;
    private Version version;

    public RemoteBundle(OSGiRuntimeImpl runtime, ManagedBundleMBean bundle, String location) {
        this.runtime = runtime;
        this.bundle = bundle;
        this.location = location;
        this.bundleId = bundle.getBundleId();
        this.symbolicName = bundle.getSymbolicName();
        String versionStr = this.getHeaders().get("Bundle-Version");
        this.version = Version.parseVersion((String)versionStr);
    }

    @Override
    public int getState() {
        return this.uninstalled ? 1 : this.bundle.getState();
    }

    @Override
    public long getBundleId() {
        return this.bundleId;
    }

    @Override
    public String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        this.assertNotUninstalled();
        return this.bundle.getHeaders();
    }

    @Override
    public String getProperty(String key) {
        this.assertNotUninstalled();
        return this.bundle.getProperty(key);
    }

    @Override
    public void start() throws BundleException {
        this.assertNotUninstalled();
        this.bundle.start();
    }

    @Override
    public void stop() throws BundleException {
        this.assertNotUninstalled();
        this.bundle.stop();
    }

    @Override
    public void uninstall() throws BundleException {
        this.assertNotUninstalled();
        try {
            this.runtime.undeploy(this.location);
            this.runtime.unregisterBundle(this);
            this.uninstalled = true;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            log.error((Object)("Cannot uninstall: " + this.location), (Throwable)ex);
        }
    }

    private void assertNotUninstalled() {
        if (this.uninstalled) {
            throw new IllegalStateException("Bundle already uninstalled: " + this.location);
        }
    }
}

