/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing;

import org.jboss.osgi.testing.OSGiRuntime;
import org.jboss.osgi.testing.OSGiRuntimeHelper;
import org.jboss.osgi.testing.OSGiTest;
import org.jboss.osgi.testing.internal.EmbeddedRuntime;
import org.jboss.osgi.testing.internal.RemoteRuntime;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;

public abstract class OSGiRuntimeTest
extends OSGiTest {
    private static OSGiRuntime runtime;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (runtime == null && !this.isBeforeClassPresent()) {
            runtime = OSGiRuntimeTest.createDefaultRuntime();
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        OSGiRuntimeTest.shutdownRuntime();
    }

    public static void shutdownRuntime() {
        if (runtime != null) {
            runtime.shutdown();
            runtime = null;
        }
    }

    public static OSGiRuntime getRuntime() {
        if (runtime == null) {
            throw new IllegalStateException("OSGiRuntime not available. Use createRuntime()");
        }
        return runtime;
    }

    public static OSGiRuntime createDefaultRuntime() {
        String target = System.getProperty("target.container");
        if (target == null) {
            return OSGiRuntimeTest.createEmbeddedRuntime();
        }
        return OSGiRuntimeTest.createRemoteRuntime();
    }

    public static OSGiRuntime createEmbeddedRuntime() {
        runtime = new EmbeddedRuntime(new OSGiRuntimeHelper());
        return runtime;
    }

    public static OSGiRuntime createRemoteRuntime() {
        runtime = new RemoteRuntime(new OSGiRuntimeHelper());
        return runtime;
    }
}

