/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;

public abstract class ServiceLoader {
    private static final Logger log = Logger.getLogger(ServiceLoader.class);

    public static <T> List<T> loadServices(Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException("Null serviceClass");
        }
        ArrayList services = new ArrayList();
        ClassLoader loader = serviceClass.getClassLoader();
        String serviceClassName = System.getProperty(serviceClass.getName());
        if (serviceClassName != null) {
            try {
                Class<?> implClass = loader.loadClass(serviceClassName);
                services.add(implClass.newInstance());
                return Collections.unmodifiableList(services);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to load service: " + serviceClassName, ex);
            }
        }
        String filename = "META-INF/services/" + serviceClass.getName();
        InputStream inStream = loader.getResourceAsStream(filename);
        if (inStream == null) {
            log.debug((Object)("Cannot find resource: " + filename));
        }
        if (inStream != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
                String implClassName = br.readLine();
                while (implClassName != null) {
                    int hashIndex = implClassName.indexOf("#");
                    if (hashIndex > 0) {
                        implClassName = implClassName.substring(0, hashIndex);
                    }
                    if ((implClassName = implClassName.trim()).length() > 0) {
                        try {
                            Class<?> implClass = loader.loadClass(implClassName);
                            if (serviceClass.isAssignableFrom(implClass)) {
                                services.add(implClass.newInstance());
                            } else {
                                log.warn((Object)("Not assignable: " + implClassName));
                            }
                        }
                        catch (Exception ex) {
                            log.debug((Object)("Cannot load service: " + implClassName));
                        }
                    }
                    implClassName = br.readLine();
                }
                br.close();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to load services for: " + serviceClass.getName());
            }
        }
        return Collections.unmodifiableList(services);
    }

    public static <T> T loadService(Class<T> serviceClass) {
        List<T> services = ServiceLoader.loadServices(serviceClass);
        if (services.isEmpty()) {
            return null;
        }
        return services.get(0);
    }
}

