/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing.internal;

import java.io.File;
import java.net.URL;
import java.util.Dictionary;
import org.jboss.osgi.testing.OSGiBundle;
import org.jboss.osgi.testing.internal.EmbeddedRuntime;
import org.jboss.osgi.testing.internal.OSGiBundleImpl;
import org.jboss.osgi.testing.internal.OSGiRuntimeImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;

public class EmbeddedBundle
extends OSGiBundleImpl {
    private Bundle bundle;

    public EmbeddedBundle(OSGiRuntimeImpl runtime, Bundle bundle) {
        super(runtime);
        this.bundle = bundle;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public int getState() {
        return this.bundle.getState();
    }

    @Override
    public String getSymbolicName() {
        return this.bundle.getSymbolicName();
    }

    @Override
    public Version getVersion() {
        return this.bundle.getVersion();
    }

    @Override
    public String getLocation() {
        return this.bundle.getLocation();
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        return this.bundle.getHeaders();
    }

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        return this.bundle.getHeaders(locale);
    }

    @Override
    public long getBundleId() {
        return this.bundle.getBundleId();
    }

    @Override
    public String getProperty(String key) {
        return this.bundle.getBundleContext().getProperty(key);
    }

    @Override
    public URL getEntry(String path) {
        return this.bundle.getEntry(path);
    }

    @Override
    public URL getResource(String name) {
        return this.bundle.getResource(name);
    }

    @Override
    public File getDataFile(String filename) {
        return this.bundle.getBundleContext().getDataFile(filename);
    }

    @Override
    public OSGiBundle loadClass(String name) throws ClassNotFoundException {
        Class clazz = this.bundle.loadClass(name);
        Bundle providerBundle = this.getPackageAdmin().getBundle(clazz);
        if (providerBundle == null) {
            return null;
        }
        return this.getRuntime().getBundle(providerBundle.getBundleId());
    }

    @Override
    protected void startInternal() throws BundleException {
        this.bundle.start();
    }

    @Override
    protected void stopInternal() throws BundleException {
        this.bundle.stop();
    }

    @Override
    protected void uninstallInternal() throws BundleException {
        this.assertNotUninstalled();
        this.bundle.uninstall();
        OSGiRuntimeImpl runtimeImpl = (OSGiRuntimeImpl)this.getRuntime();
        runtimeImpl.unregisterBundle(this);
    }

    private PackageAdmin getPackageAdmin() {
        BundleContext context = ((EmbeddedRuntime)this.getRuntime()).getSystemContext();
        ServiceReference sref = context.getServiceReference(PackageAdmin.class.getName());
        return (PackageAdmin)context.getService(sref);
    }
}

