/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing.internal;

import java.net.URL;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.osgi.jmx.ObjectNameFactory;
import org.jboss.osgi.testing.OSGiRuntime;
import org.osgi.framework.BundleException;

class MainDeployerClient {
    private final OSGiRuntime runtime;

    MainDeployerClient(OSGiRuntime runtime) {
        this.runtime = runtime;
    }

    public void deploy(URL url) throws BundleException {
        this.invokeDeployerMBean("deploy", url);
    }

    public void undeploy(URL url) throws BundleException {
        this.invokeDeployerMBean("undeploy", url);
    }

    private void invokeDeployerMBean(String method, URL url) throws BundleException {
        try {
            MBeanServerConnection mbeanServer = this.runtime.getMBeanServer();
            ObjectName objectName = ObjectNameFactory.create((String)"jboss.system:service=MainDeployer");
            mbeanServer.invoke(objectName, method, new Object[]{url}, new String[]{URL.class.getName()});
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            if (ex instanceof MBeanException && (ex = ((MBeanException)ex).getTargetException()) instanceof BundleException) {
                throw (BundleException)ex;
            }
            throw new BundleException("Cannot " + method + ": " + url, (Throwable)ex);
        }
    }
}

