/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.testing.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import org.jboss.osgi.spi.capability.Capability;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.service.DeployerService;
import org.jboss.osgi.spi.testing.OSGiBundle;
import org.jboss.osgi.spi.testing.OSGiPackageAdmin;
import org.jboss.osgi.spi.testing.OSGiServiceReference;
import org.jboss.osgi.spi.testing.OSGiTestHelper;
import org.jboss.osgi.spi.testing.internal.EmbeddedBundle;
import org.jboss.osgi.spi.testing.internal.EmbeddedPackageAdmin;
import org.jboss.osgi.spi.testing.internal.EmbeddedServiceReference;
import org.jboss.osgi.spi.testing.internal.OSGiRuntimeImpl;
import org.jboss.osgi.spi.util.BundleDeployment;
import org.jboss.osgi.spi.util.BundleDeploymentFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;
import org.osgi.service.packageadmin.PackageAdmin;

public class EmbeddedRuntime
extends OSGiRuntimeImpl {
    public EmbeddedRuntime(OSGiTestHelper helper) {
        super(helper);
    }

    public OSGiBundle installBundle(String location) throws BundleException {
        OSGiBundle bundle;
        URL bundleURL = this.getTestHelper().getTestArchiveURL(location);
        BundleDeployment bundleDep = BundleDeploymentFactory.createBundleDeployment(bundleURL);
        String symbolicName = bundleDep.getSymbolicName();
        Version version = Version.parseVersion((String)bundleDep.getVersion());
        BundleContext context = this.getBundleContext();
        ServiceReference sref = context.getServiceReference(DeployerService.class.getName());
        if (sref != null) {
            DeployerService service = (DeployerService)context.getService(sref);
            service.deploy(bundleURL);
            bundle = this.getBundle(symbolicName, version, true);
        } else {
            Bundle auxBundle = context.installBundle(bundleURL.toExternalForm());
            bundle = new EmbeddedBundle(this, auxBundle);
        }
        return this.registerBundle(location, bundle);
    }

    public OSGiBundle[] getBundles() {
        ArrayList<EmbeddedBundle> absBundles = new ArrayList<EmbeddedBundle>();
        for (Bundle bundle : this.getBundleContext().getBundles()) {
            absBundles.add(new EmbeddedBundle(this, bundle));
        }
        OSGiBundle[] bundleArr = new OSGiBundle[absBundles.size()];
        absBundles.toArray(bundleArr);
        return bundleArr;
    }

    public OSGiBundle getBundle(long bundleId) {
        Bundle bundle = this.getBundleContext().getBundle(bundleId);
        return bundle != null ? new EmbeddedBundle(this, bundle) : null;
    }

    public OSGiServiceReference getServiceReference(String clazz) {
        ServiceReference sref = this.getBundleContext().getServiceReference(clazz);
        return sref != null ? new EmbeddedServiceReference(sref) : null;
    }

    public OSGiServiceReference[] getServiceReferences(String clazz, String filter) {
        ServiceReference[] srefs;
        OSGiServiceReference[] retRefs = null;
        try {
            srefs = this.getBundleContext().getServiceReferences(clazz, filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter syntax: " + filter);
        }
        if (srefs != null) {
            retRefs = new OSGiServiceReference[srefs.length];
            for (int i = 0; i < srefs.length; ++i) {
                retRefs[i] = new EmbeddedServiceReference(srefs[i]);
            }
        }
        return retRefs;
    }

    public void addCapability(Capability capability) throws BundleException {
        Map<String, String> props = capability.getSystemProperties();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String value = System.getProperty(entry.getKey());
            if (value != null) continue;
            System.setProperty(entry.getKey(), entry.getValue());
        }
        super.addCapability(capability);
    }

    public void shutdown() {
        OSGiBootstrapProvider bootProvider = this.getTestHelper().getBootstrapProvider();
        if (bootProvider != null) {
            super.shutdown();
            try {
                Framework framework = bootProvider.getFramework();
                framework.stop();
                framework.waitForStop(5000L);
            }
            catch (Exception ex) {
                this.log.error((Object)"Cannot stop the framework", (Throwable)ex);
            }
        }
    }

    public BundleContext getBundleContext() {
        OSGiBootstrapProvider bootProvider = this.getTestHelper().getBootstrapProvider();
        Framework framework = bootProvider.getFramework();
        if (framework.getState() != 32) {
            try {
                framework.start();
            }
            catch (BundleException ex) {
                throw new IllegalStateException("Cannot start framework", ex);
            }
        }
        return framework.getBundleContext();
    }

    public MBeanServerConnection getMBeanServer() {
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            throw new IllegalStateException("Multiple MBeanServer instances not supported");
        }
        MBeanServer server = null;
        if (serverArr.size() == 1) {
            server = serverArr.get(0);
        }
        if (server == null) {
            server = MBeanServerFactory.createMBeanServer();
        }
        return server;
    }

    public OSGiPackageAdmin getPackageAdmin() {
        BundleContext context = this.getBundleContext();
        ServiceReference sref = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packAdmin = (PackageAdmin)context.getService(sref);
        return new EmbeddedPackageAdmin(packAdmin);
    }
}

