/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.util;

import java.io.Serializable;
import java.net.URL;

public class BundleDeployment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private URL location;
    private String symbolicName;
    private String version;
    private int startLevel;
    private boolean autoStart;
    private Object metadata;

    public BundleDeployment(URL location, String symbolicName, String version) {
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null");
        }
        if (symbolicName == null) {
            throw new IllegalArgumentException("Symbolic name cannot be null");
        }
        if (version == null) {
            version = "0.0.0";
        }
        this.symbolicName = symbolicName;
        this.location = location;
        this.version = version;
    }

    public URL getLocation() {
        return this.location;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(int startLevel) {
        this.startLevel = startLevel;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BundleDeployment)) {
            return false;
        }
        BundleDeployment other = (BundleDeployment)obj;
        return this.symbolicName.equals(other.symbolicName) && this.version.equals(other.version);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "[" + this.symbolicName + "-" + this.version + ",url=" + this.location + "]";
    }
}

